new;
library gdr,pgraph;
gdrSet;

sigma = 0.015;

N = 5001; h = 10 / N;
t = seqa(0,h,N);

rndseed 123;
w = recserar(sigma * rndn(N,1)*sqrt(h),0,1);
lambda = w^2;

I = zeros(N,1);

k = 2;
do until k > N;
  wgt = ones(k,1); wgt[1] = 0.5; wgt[k] = 0.5;
  I[k] = sumc(wgt .* lambda[1:k]);
  k = k + 1;
endo;

theta = rndExp(1,1,1);

tau = t[maxindc(I .> theta)];

I = I .* (I .< theta) + theta .* (I .> theta);

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6; _plwidth = 10;
  xtics(0,10,2,2);
  xlabel("\216t");

  _pcolor = 5;
  ylabel("\216\202L\201(t)");
  ytics(0,1.50,0.25,2);
  _parrow = tau~theta~0~theta~1~0.125~21~4~1~1~10 |
            tau~0~tau~theta~1~0.125~21~4~1~1~10 ;
  _pmsgstr = "\202Q\201\000\202t\201";
  _pmsgctl = -0.45~0.975*theta~0.2~0~1~4~10 |
               tau*0.95~-0.10~0.2~0~1~4~10 ;
  graphprt("-c=1 -cf=param6.Eps");
  xy(t,I);