new;
library gdr,pgraph;

let iTraxx_Detach = 3 	6 	9 	12 	22 ;	
let iTraxx_Rho = 19.0 	30.9 	39.9 	46.7 	62.4;

K = iTraxx_Detach;
SkewCDO = iTraxx_Rho;

let c = 0.01 0.005;
r = 1;

Ns = 10000;
b = rndu(Ns,1);
U = zeros(2,Ns);
i = 1;
do until i > Ns;
  if b[i] < 0.10;
    U[.,i] = b[i] * ones(2,1);
  else;
    U[.,i] = 0.1 + 0.9 * rndu(2,1);
  endif;
  i = i + 1;
endo;
u = u';

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(4.5,3.5,4.35,1.00,1);

  _pcross = 0; _pdate = 0; _pframe = 0; _pnum = 2;
  fonts("simplex simgrma");

  setwind(1);

    _plctrl = 1; _plwidth = 10; _pstype = 8|9;
    _pltype = 6|3; _pcolor = 1|4;

    xtics(0,24,2,0);
    ytics(0,70,10,0);

    xlabel("\216Strike (en %)");
    ylabel("\216Correlation (en %)");
    _pmsgstr = "\202\39\201";
    _pmsgctl = 0.38~3.22~0.17~90~2~0~5;

    i = 1;
    do until i > r;      
      SkewCDOFile = Skew2Copula_StringName("itraxx-Skew2Rho",c[i]) $+ ".fmt";
      load SkewRho = ^SkewCDOFile;
      SkewCDO = MergeMatrix(SkewCDO,100*SkewRho);
      i = i + 1;
    endo;

    _plegstr = "iTraxx 5 ans\000Somme ordinale";
    _plegctl = {2 5 1.25 5.5};
    xy(K,SkewCDO);

  setwind(2);
    title("\216Somme ordinale (C[+];C[\202\74\201];0,1)");
    _plctrl = -1; _pstype = 4; _psymsiz = 1; _pcolor = 1;
    _pnumht = 0.22; _paxht = 0.22; _ptitlht = 0.25; 
    _plegctl = 0;
    xlabel("\216U]1["); ylabel("\216U]2[");
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);
    _pline = 1~6~0.1~0.0~0.1~1.0~1~0~5 |
             1~6~0.0~0.1~1.0~0.1~1~0~5 ;
    _pline = _pline |
             1~6~0.1~0.0~0.1~0.1~1~4~10 |
             1~6~0.0~0.1~0.1~0.1~1~4~10 |
             1~6~0.0~0.0~0.0~0.1~1~4~10 |
             1~6~0.0~0.0~0.1~0.0~1~4~10 |
             1~6~1~0.1~1~1~1~2~10 |
             1~6~0.1~1~1~1~1~2~10 |
             1~6~0.1~0.1~0.1~1~1~2~10 |
             1~6~0.1~0.1~1~0.1~1~2~10 ;
    _pmsgstr = "C[+]\000C[\202\74\201]";
    _pmsgctl = {0.025 0.15 .2 0 1 4 8,
                0.5 0.5 .5 0 1 0 15};
    xy(u[.,1],u[.,2]);

  graphprt("-c=1 -cf=param57.eps");

  endwind;



