new;
library gdr,pgraph;

let Rho   = 0.005;
let alpha = 0.60;

_SkewCopula_zMax = 6;
_SkewCopula_zMin = -6;
_SkewCopula_n = 601;
_SkewCopula_Quad_xMax = 7;
_SkewCopula_Quad_xMin = -7;
_SkewCopula_Quad_order = 1024;

x = seqa(-5,0.1,101);
_SkewCopula_Model = 1;
Beta = _SkewCopula_Beta(x,rho,alpha);

nS = 50000;
rndseed 123;
gX = _SkewCopula_Simulate_gX(rho,alpha,nS);
gX = (gX - meanc(gX))/stdc(gX); 
_Kernel[1:2] = -5|5;
{xGX,dGX,FGX,retcode} = Kernel(gX);

t = seqa(-pi/2,pi/100,101);
t = trimr(t,1,1);

c = sin(t);
t1 = t | t + t[rows(t)] - t[1];
c1 = c | rev(c);
t1 = t1 | t1 + t1[rows(t1)] - t1[1];
c1 = c1 | rev(c1);
t1 = t1 | t1 + t1[rows(t1)] - t1[1];
c1 = c1 | rev(c1);

c = 2*Match(gX,cdfni((c+1)/2)) - 1.0;
t2 = t | t + t[rows(t)] - t[1];
c2 = c | rev(c);
t2 = t2 | t2 + t2[rows(t2)] - t2[1];
c2 = c2 | rev(c2);
t2 = t2 | t2 + t2[rows(t2)] - t2[1];
c2 = c2 | rev(c2);

proc (1) = Match(y,x);
  local Nx,N,h,d,F;
  local function,i,u,KK;

  Nx = rows(x);
  N = rows(y);
  h = 1.364*stdc(y)*(N^(-0.2));
  d = zeros(Nx,1); 
  F = d;

  function = &_Kernel_Gauss;
  local function : proc;

  i = 1;
  do until i > Nx;
    u = (x[i]-y)/h;
    KK = function(u);
    d[i] = sumc(KK)/(N*h);
    if i>1;
      F[i] = F[i-1]+0.5*(d[i]+d[i-1])*(x[i]-x[i-1]);
    endif;
    i = i + 1;
  endo;

  retp(F);
endp;

rndseed 123;
Ns = 5000;
SkewCopula_Init(rho,alpha);
u = SkewCopula_Simulate(2,Ns);

graphset;
  begwind;
  window(2,2,1);
  
  _pdate = ""; _pnum = 2; _pframe = 0; _pcross = 1;
  _pltype = 6|3; _plwidth = 10; _pcolor = 10|13;
  _pnumht = 0.22; _ptitlht = 0.25; _paxht = 0.22;
  fonts("simplex simgrma");

  _pcolor = 1|5;

  setwind(1);
    title("\216\201Fonction \202r\201(X)=\202b\201[2](X)");
    xlabel("\216\201X");
    xtics(-4,4,1,2);
    ytics(0,1,0.2,2);
    xy(x,Beta);

  setwind(2);
    title("\216\201PDF de \202b\201(X)X");
    xlabel("\216\201X");
    xtics(-5,5,1,2);
    ytics(0,1.5,0.5,2);
    xy(xGX,dGX~pdfn(xgX));

  setwind(3);
    title("\216\201Cycle");
    _pcross = 1; 
    xtics(0,14,2,2);
    ytics(-1.5,1.5,0.5,2);
    let ylab = " "  " " " " " " " " " ";
    asclabel(0,ylab);
    xy(7*(t2~t1)/(2*pi),1.1*c2~c1);

  setwind(4);
    title("\216\201Fonction copule");
    _pcross = 0; 
    _plctrl = -1; _pstype = 4; _psymsiz = 1;
    fonts("simplex simgrma");
    xlabel("\216U]1["); ylabel("\216U]2[");
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);
    _pline = 1~6~0.5~0.0~0.5~1.0~1~0~10 |
             1~6~0.0~0.5~1.0~0.5~1~0~10 ;
    _pline = _pline|
             4~3~0.0~0.0~0.04~0~2~4~15;
    xy(u[.,1],u[.,2]);

  graphprt("-c=1 -cf=param56.eps");

  endwind;