new;
library gdr,pgraph;

let iTraxx_Detach = 3 	6 	9 	12 	22 ;	
let iTraxx_Rho = 19.0	30.9	39.9	46.7	62.4;

let Rho   = 0.005;
let alpha = 0.60;

Skew_Detach = iTraxx_Detach;

K = iTraxx_Detach;
SkewCDO = iTraxx_Rho;

r = rows(Rho);
i = 1;
do until i > r;
  SkewCDOFile = SkewCopula_StringName("itraxx-SkewRho",rho[i],alpha[i]) $+ ".fmt";
  load SkewRho = ^SkewCDOFile;
  SkewCDO = MergeMatrix(SkewCDO,100*SkewRho);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = 1; _plwidth = 10; _pstype = 8|9;
  _pltype = 6|3; _pcolor = 1|4;
  xtics(0,24,2,0);
  ytics(0,70,10,0);

  xlabel("\216Strike (en %)");
  ylabel("\216Correlation (en %)");
  _pmsgstr = "\202\39\201";
  _pmsgctl = 0.38~3.22~0.17~90~2~0~5;

  _plegstr = "iTraxx 5 ans\000\202r\201 = 0,5% et \202a\201 = 60%";
  _plegctl = {2 5 4 2};
  graphprt("-c=1 -cf=param55.eps");
  xy(K,SkewCDO);