new;
library gdr,pgraph;

let iTraxx_Detach = 3 	6 	9 	12 	22 ;	
let iTraxx_Rho = 19.0 	30.9 	39.9 	46.7 	62.4;

let Detach = 0.03 0.06 0.09 0.12 0.22;

let rho =   0.02 0.01 0.05 0.05 0.04 0.04 0.03 0.03 0.02 0.02 0.001 0.15 0.20 0.15
            0.03 0.01 0.01 0.01 0.005 0.005 0.005;
let alpha = 0.80 0.80 0.50 0.60 0.50 0.60 0.05 0.60 0.05 0.60 0.800 0.10 0.10 0.20
            0.50 0.50 0.55 0.60 0.50  0.55  0.60;

m = rows(rho);
rho = rho[1:m];
alpha = alpha[1:m];

K = iTraxx_Detach;
SkewCDO = iTraxx_Rho;

i = 1;
do until i > rows(rho);
  SkewCDOFile = SkewCopula_StringName("itraxx-SkewRho",rho[i],alpha[i]) $+ ".fmt";
  load SkewRho = ^SkewCDOFile;
  K = MergeMatrix(K,100*Detach);
  SkewCDO = MergeMatrix(SkewCDO,100*SkewRho);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = 1; _plwidth = 20|10*ones(m,1); _pstype = 8|9|10|11; _psymsiz = 4;
  xtics(0,27,3,0);
  ytics(0,65,5,0);
  _plegstr = "iTraxx 5Y\000" $+
             MakeMsgStr("Skew Copula " $+ ftosa(100*Rho,"(\202r\201=%lf",1,error(0)) $+ "%" $+ ftosa(Alpha,",\202a\201=%lf)",2,1));
  _plegctl = {2 4 5.5 0.5};
  xy(K,SkewCDO);
