new;
library gdr,pgraph;

let iTraxx_Detach = 3 	6 	9 	12 	22 ;	
let iTraxx_Rho = 19.0 	30.9 	39.9 	46.7 	62.4;

{Notional,HazardRate,RR} = Generate_CDO(100,100/1e4,0.40);
{DF,Delta} = Generate_DF(0.04,0.25,5);

Attach = 0;
let Detach = 0.03 0.06 0.09 0.12 0.22;

_CDO_Pricing_Ns = 1e6;
_CDO_Pricing_maxRho = 0.80;

_SkewCopula_Quad_order = 512;
nS = 1000|1000;
nF = 100;
NameFile = 0;

let c = 0.01 0.005;

_SkewCopula_Print = 0;

i = 1;
do until i > rows(c);
  call Skew2Copula_Simulate_DataBase(c[i],nS,nF,NameFile);

  DatFile = Skew2Copula_FileName(c[i]);
  SpreadCDOFile = Skew2Copula_StringName("itraxx-Skew2Spread",c[i]) $+ ".fmt";
  SkewCDOFile = Skew2Copula_StringName("itraxx-Skew2Rho",c[i]) $+ ".fmt";

  SpreadCDO = _CDO_Pricing_Skew_2(HazardRate,RR,Attach,Detach,DF,delta,DatFile);
  save ^SpreadCDOFile = SpreadCDO;

  load Spread = ^SpreadCDOFile;
  SkewCDO = _CDO_Pricing_Implied(HazardRate,RR,Attach,Detach,DF,delta,Spread);
  save ^SkewCDOFile = SkewCDO;

  load SkewRho = ^SkewCDOFile;
  K = MergeMatrix(iTraxx_Detach,100*Detach);
  SkewCDO = MergeMatrix(iTraxx_Rho,100*SkewRho);

  graphset;
    fonts("simplex simgrma");
    _pdate = ""; _pnum = 2; _pframe = 0;
    _plctrl = 1; _plwidth = 10; _pstype = 8|9|10|11; _psymsiz = 4;
    xtics(0,24,3,0);
    ytics(0,70,10,0);
    _plegstr = "iTraxx 5Y\000Skew Copula " $+ ftos(100*c[i],"(\202c\201=%lf",2,1);
    _plegctl = {2 5 4 1};
    xy(K,SkewCDO);

  i = i + 1;
endo;

