new;
library gdr,pgraph;

let Rho   = 0.05 0.20 0.20 0.20;
let alpha = 0.50 0.50 0.10 1.00;

Detach = seqa(0.01,0.01,20);

SkewRhoCDO = zeros(rows(Detach),rows(Rho));

i = 1;
do until i > rows(Rho);
  RhoFile = SkewCopula_StringName("SkewRho",rho[i],alpha[i]) $+ ".fmt";
  loadm RhoCDO = ^RhoFile;
  SkewRhoCDO[.,i] = RhoCDO;
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plwidth = 10; _pltype = 6|3|1|5; _pcolor = 1|2|4|5;  
  xtics(0,20,5,2);  
  ytics(20,60,10,2);

  xlabel("\216Strike (en %)");
  ylabel("\216Correlation (en %)");
  _pmsgstr = "\202\39\201";
  _pmsgctl = 0.38~3.22~0.17~90~2~0~5;

  _plegstr = "(\202r\201= 5% / \202a\201=0,5)\000(\202r\201=20% / \202a\201=0,5)\000"\
             "(\202r\201=20% / \202a\201=0,1)\000(\202r\201=20% / \202a\201=1,0)";

  _plegctl = {2 5 5.75 3.15};
  graphprt("-c=1 -cf=param51.eps");
  xy(100*Detach,100*SkewRhoCDO);

