new;
library gdr,pgraph;

{Notional,HazardRate,RR} = Generate_CDO(100,100/1e4,0.40);
{DF,Delta} = Generate_DF(0.04,0.25,5);

let rho =   0.20;
let alpha = 0.25;

Attach = 0;
Detach = seqa(0.01,0.01,20);

_CDO_Pricing_Ns = 1e6;
_CDO_Pricing_maxRho = 0.80;

i = 1;
do until i > rows(rho);

  SpreadFile = SkewCopula_StringName("SkewSpread",rho[i],alpha[i]) $+ ".fmt";
  RhoFile = SkewCopula_StringName("SkewRho",rho[i],alpha[i]) $+ ".fmt";
  DatFile = SkewCopula_FileName(rho[i],alpha[i]);

  Spread = _CDO_Pricing_Skew_2(HazardRate,RR,Attach,Detach,DF,delta,DatFile);
  save ^SpreadFile = Spread;

  load Spread = ^SpreadFile;
  newRho = _CDO_Pricing_Implied(HazardRate,RR,Attach,Detach,DF,delta,Spread);
  save ^RhoFile = newRho;

  print /flush i;

  i = i + 1;
endo;




