new;
library gdr,pgraph;
gdrSet;

sigma = 0.015;

N = 5001; h = 10 / N;
t = seqa(0,h,N);

rndseed 123;
w = recserar(sigma * rndn(N,1)*sqrt(h),0,1);
lambda = w^2;

I = zeros(N,1);

k = 2;
do until k > N;
  wgt = ones(k,1); wgt[1] = 0.5; wgt[k] = 0.5;
  I[k] = sumc(wgt .* lambda[1:k]);
  k = k + 1;
endo;

theta = rndExp(1,1,1);

tau = t[maxindc(I .> theta)];

indx = seqa(1,20,N/20);

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,1);
  makewind(9/2,6.855/2,9/2,6.855/2,1);
  makewind(9/2,6.855/2,9/4,0,1);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6; _plwidth = 10;
  xtics(0,10,2,2);
  _paxht = 0.30; _pnumht = 0.20; _ptitlht = 0.25;
  xlabel("\216t");

  setwind(1);
    _pcolor = 1;
    ylabel("\216W(t)");
    ytics(-0.02,0.05,0.01,2);
    xy(t[indx],w[indx]);
  setwind(2);
    _pcolor = 4;
    ylabel("\216\202l\201(t)");
    ytics(0,0.0025,0.0005,2);
    xy(t[indx],lambda[indx]);
  setwind(3);
    _pcolor = 5;
    ylabel("\216\202L\201(t)");
    ytics(0,1.50,0.25,2);

    _pline = 1~4~0~theta~10~theta~1~4~5 |
             1~4~tau~0~tau~theta~1~4~5 ;

    _parrow = 0~theta~tau~theta~1~0.125~21~4~1~1~10 |
              tau~theta~tau~0  ~1~0.125~21~4~1~1~10 ;
    _pmsgstr = "\202Q\201\000\202t\201";
    _pmsgctl = -0.75~0.95*theta~0.3~0~1~4~10 |
               tau*0.90~-0.15~0.3~0~1~4~10 ;
    xy(t,I);

    graphprt("-c=1 -cf=param5.eps");

  endwind;