new;
library gdr,pgraph;

{Notional,HazardRate,RR} = Generate_CDO(100,100/1e4,0.40);
{DF,Delta} = Generate_DF(0.04,0.25,5);

Rho = 0.20;
alpha = 0.5;
SpreadFile = SkewCopula_StringName("SkewSpread",rho,alpha) $+ ".fmt";
RhoFile = SkewCopula_StringName("SkewRho",rho,alpha) $+ ".fmt";

Attach = 0;
Detach = seqa(0.01,0.01,20);

_CDO_Pricing_Ns = 1e6;
Spread = _CDO_Pricing_Skew_2(HazardRate,RR,Attach,Detach,DF,delta,SkewCopula_FileName(rho,alpha));
save ^SpreadFile = Spread;

_CDO_Pricing_maxRho = 0.80;
load Spread = ^SpreadFile;
newRho = _CDO_Pricing_Implied(HazardRate,RR,Attach,Detach,DF,delta,Spread);
save ^RhoFile = newRho;

