new;
library gdr,pgraph;

cls;

proc simulate(p,rho1,rho2,ns);
  local Y,rho,X,epsilon,Z;
  Y = rndu(ns,2) .<= p;
  rho = rho1 .* (1 - Y) + rho2 .* Y;
  X = rndn(ns,1);
  epsilon = rndn(ns,2);
  Z = sqrt(rho) .* X + sqrt(1-rho) .* epsilon;
  retp(Z);
endp;

rho1 = 0;
rho2 = 1;
ns = 1000;

rndseed 123;
p = 0.05;
z = simulate(p,rho1,rho2,ns);
u1 = Dependogram(z);

rndseed 123;
p = 0.10;
z = simulate(p,rho1,rho2,ns);
u2 = Dependogram(z);

rndseed 123;
p = 0.50;
z = simulate(p,rho1,rho2,ns);
u3 = Dependogram(z);

rndseed 123;
p = 0.90;
z = simulate(p,rho1,rho2,ns);
u4 = Dependogram(z);

graphset;
  begwind;
  window(2,2,0);
    _pdate = ""; _pnum = 2; _pframe = 0; _pcross = 1;
    _plctrl = -1; _pstype = 4; _psymsiz = 5;
    _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.30;
    fonts("simplex simgrma");
    xlabel("\216U]1["); ylabel("\216U]2[");
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);

  setwind(1);
    title("\216p = 5%");
    _pcolor = 1;
    xy(u1[.,1],u1[.,2]);

  setwind(2);
    title("\216p = 10%");
    _pcolor = 2;
    xy(u2[.,1],u2[.,2]);

  setwind(3);
    title("\216p = 50%");
    _pcolor = 12;
    xy(u3[.,1],u3[.,2]);

  setwind(4);
    title("\216p = 90%");
    _pcolor = 5;
    xy(u4[.,1],u4[.,2]);

    graphprt("-c=1 -cf=param37.eps");

  endwind;

