new;
library gdr,pgraph;
gdrSet;

cls;

rndseed 123456;

let PD = 0.2;
let rho = 0.00 0.20 0.50 0.90;
rho = rho';
N = 1000;
Nt = 1000000;

d = zeros(Nt,cols(rho));
X = rndn(Nt,1);
i = 1;
do until i > Nt;
  epsilon = rndn(N,1);
  isD = (sqrt(rho) .* X[i] + sqrt(1-rho) .* epsilon) .< cdfni(PD);
  d[i,.] = sumc(isD)';
  i = i + 1;
endo;

mu = d / N;

output file = param33.out reset;

stats = meanc(mu)~stdc(mu)~quantile(mu,0.01|0.05|0.10|0.25|0.50|0.75|0.90|0.95|0.99)';
print 100*stats;

output off;


graphset;
  begwind;
  window(2,2,0);
  xtics(0,1,0.2,2); 

  _pdate = ""; _pframe = 0; _pnum = 2;
  _pnumht = 0.225; _paxht = 0.20; _ptitlht = 0.30;
  v = 50;
  xlabel("\000"); ylabel("\000");
  fonts("simplex simgrma");

  i = 1;
  setwind(i);
    title("\216\202r\201 = 0%");
    _pbartyp = 6~1;
    call histp(mu[.,i],v);

  i = 2;
  setwind(i);
    title("\216\202r\201 = 20%");
    _pbartyp = 6~2;
    call histp(mu[.,i],v);

  i = 3;
  setwind(i);
    ytics(0,20,5,5);
    title("\216\202r\201 = 50%");
    _pbartyp = 6~5;
    call histp(mu[.,i],v);

  i = 4;
  setwind(i);
    ytics(0,60,15,3);
    title("\216\202r\201 = 90%");
    _pbartyp = 6~4;
    call histp(mu[.,i],v);

    graphprt("-c=1 -cf=param33.eps");

  endwind;