new;
library gdr,pgraph;
gdrset;

cls;

lambda1 = 100;
lambda2 = 50;

bnds = 5000;
order = 128;

T = seqa(1,1,10);

rho = 0.20;
nu = 4;

lambda1 = lambda1/1e4;
lambda2 = lambda2/1e4;

fn S1(t) = exp(-lambda1 .* t);
fn S2(t) = exp(-lambda2 .* t); 
fn PD1(t) = 1 - S1(t);
fn PD2(t) = 1 - S2(t);

P1 = PD1(T);
P2 = PD2(T');

output file = param31.out reset;

cor1 = defaultCorrelation(P1,P2,rho,0);
cor2 = defaultCorrelation(P1,P2,rho,nu);

call printfmt2(100*cor1,1,1); print;
call printfmt2(100*cor2,1,1);

cor4 = SurvivalCorrelation(&S1,&S2,rho,0,bnds,order);
print 100*cor4;

cor5 = SurvivalCorrelation(&S1,&S2,rho,nu,bnds,order);
print 100*cor5;

output off;

quadLegendre1(&S1,bnds|0,order);
