new;
library gdr,pgraph;
gdrSet;

r = 10000;
c = 3;

/*
**> Mixture of exponential survival functions
*/

theta1 = 0.5;
lambda1 = 0.01;
lambda2 = 0.02;

fn S(t) = theta1 * exp(-lambda1*t) + 
          (1-theta1) * exp(-lambda2*t);
fn f(t) = theta1 * lambda1 * exp(-lambda1*t) + 
          (1-theta1) * lambda2 * exp(-lambda2*t);

rndseed 123;
u = rnd_NR(r,c,&S,&f);  /* using the analytical expression of the density */
call dstat(0,u);

rndseed 123;
u = rnd_NR(r,c,&S,0);   /* without the analytical expression of the density */
call dstat(0,u);

