new;
library gdr,pgraph;
gdrSet;

cls;

proc cndCopulaNormal2(u1,u2,rho);
  retp( cdfn((cdfni(u1) - rho.*cdfni(u2)) ./ sqrt(1-rho^2)) );
endp;

SetTransitionMatrix(1);
P = _cm_PI;

__macheps = 1e-300;
{Lambda,tmp} = FindGenerator(P);
{tmp,Lambda} = ValidGenerator(Lambda);

dt = 1/10;
t = seqa(0,dt,1001);
S = SurvivalRatings(t,Lambda);
f = pdfRatings(t,Lambda);
h = f ./ S;

Rating = 1;
t0 = 10;

let rho = 0.50;
S0 = SurvivalRatings(t0,Lambda);
Sc = cndCopulaNormal2(S,S0[Rating],rho);
hc = (lag1(Sc) - Sc) ./ Sc ./ dt ;
hc = missrv(missex(hc, t .<= t0),h);
h = 1e4*hc;

graphset;
  begwind;
  window(2,2,0);

  _pline = 1~6~t0~0~t0~1e4~1~0~10;

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3; _plwidth = 10; _pcolor = 1|4;
  xlabel("\216t");
  ylabel("\216\202l\201(t)");
  xtics(0,100,25,5);
  _plegctl = {2 6 5 3};
  _paxht = 0.30; _pnumht = 0.20; _ptitlht = 0.25;

  setwind(1);
    _plegstr = "AAA\00AA"; 
    ytics(0,400,100,2);
    xy(t,h[.,1:2]);

  setwind(2);
    _plegstr = "A\00BBB"; 
    _plegctl = {2 6 6 5};
    ytics(0,750,250,2);
    xy(t,h[.,3:4]);

  _plegctl = {2 6 5 3};

  setwind(3);
    _plegstr = "BB\00B";
    ytics(0,1500,500,1); 
    xy(t,h[.,5:6]);

  setwind(4);
    _plegstr = "CCC"; 
    ytics(0,3000,1000,2);
    xy(t,h[.,7]);

    graphprt("-c=1 -cf=param28.eps");

  endwind;
