new;
library gdr,pgraph;
gdrSet;

cls;

let rho_inter = 1
                0.2 1;

let rho_intra = 0.7 0.5;

let indx_sector = 1 2 1 2 2 1 1 1 2;
I = rows(indx_sector);

rhoStar = SmallRho(rho_inter,rho_intra); 
rho = BigRho(rhoStar,indx_sector);

format 10,3;

print rho;
{A,B} = _rndCopulaNormal3(rhoStar,indx_sector);
print A*A'+diagrv(zeros(I,I),B^2);

{A,B} = _rndCopulaNormal4(rhoStar,indx_sector);
C = A*A'+diagrv(zeros(I,I),B^2);
/* C = C ./ sqrt(diag(C)) ./sqrt(diag(C)); */
print C;

proc (2) = _rndCopulaNormal4(rhoStar,indx_sector);
  local P,A,B;

  if rows(rhoStar) == 1;
    A = sqrt(rhoStar) * ones(rows(indx_sector),1);
    B = sqrt(1-rhoStar) * ones(rows(indx_sector),1);
    retp(A,B);
  endif;

  A = chol(rhoStar)';
  B = sqrt(1-diag(rhoStar));

  retp(A[indx_sector,.],B[indx_sector]);
endp;  

