new;
library gdr,pgraph;
gdrSet;

rndseed 123;

n = 10;
let lambda = 10 10 25 25 50 
             100 250 500 500 1000;
lambda = lambda ./ 1e4;
T = 5;

ns = 100000;
EaD = 1000*ones(n,1);
D = IsDefault(n,ns,lambda,T);

let mu = 0.50 0.60 0.70 0.70;
let sigma = 0.40 0.40 0.40 0.10;

_pscreen = 0;
i = 1;
do until i > 4;

  {a,b} = calibrateBeta(mu[i],sigma[i]);
  LGD = rndBeta(n,ns,a,b);
  Loss = sumc(EaD .* LGD .* D);
 
  {c,m,frq} = hist(Loss,50);
  frq = 100*frq / rows(Loss);
  tmp = delif(m~frq,frq .== 0);
  m = tmp[.,1]; frq = tmp[.,2];
  call varput(m,ftos(i,"m%lf",1,0));
  call varput(frq,ftos(i,"f%lf",1,0));

  i = i + 1;
endo;

_pscreen = 1;

graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6; _plwidth = 10; 
  _ptitlht = 0.27; _paxht = 0.25; _pnumht = 0.20;
  _pbarwid = 0.25;

  xlabel("\216Perte");
  xtics(-500,5000,500,5);
  ytics(0,35,5,5);

  let clr = 1 2 4 5;
  i = 1;
  do until i > 4;  
    setwind(i);
    _pbartyp = 6 ~ clr[i];
    title("\216\202m\201 = " $+ ftos(mu[i]*100,"%lf",1,0) $+ 
          "%    \202s\201 = " $+ ftos(sigma[i]*100,"%lf",1,0) $+ "%" );

    bar(varget(ftos(i,"m%lf",1,0)),varget(ftos(i,"f%lf",1,0)));
    i = i + 1;
  endo;

  graphprt("-c=1 -cf=param21.eps");

  endwind;