new;
library gdr,pgraph;
gdrSet;

let r = 0.0 0.1  0.2 0.25 0.3  0.4 0.5 0.6  0.7 0.75 0.8  0.9 1.0;
let p = 0.1 0.2  1.2 2.50 1.2  0.2 0.1 0.2  1.2 2.50 1.2  0.2 0.1;
p = p / sumc(p);
mu = sumc(p .* r);
sigma = sqrt( sumc(p .* (r-mu)^2) );
{a,b} = calibrateBeta(mu,sigma);

n = 10;
let lambda = 10 10 25 25 50 
             100 250 500 500 1000;
lambda = lambda ./ 1e4;
T = 5;

ns = 100000;
EaD = 1000*ones(n,1);

rndseed 123;

LGD = rndd(n,ns,r,p);
D = IsDefault(n,ns,lambda,T);
Loss1 = sumc(EaD .* LGD .* D);

rndseed 123;

LGD = mu;
D = IsDefault(n,ns,lambda,T);
Loss2 = sumc(EaD .* LGD .* D);

rndseed 123;

LGD = rndBeta(n,ns,a,b);
D = IsDefault(n,ns,lambda,T);
Loss3 = sumc(EaD .* LGD .* D);

Loss = Loss1~Loss2~Loss3;

hist_x = zeros(50,3);
hist_y = zeros(50,3);

_pscreen = 0;
i = 1;
do until i > 3;
  {c,m,frq} = hist(Loss[.,i],50);
  frq = 100*frq / rows(Loss);
  hist_x[.,i] = m;
  hist_y[.,i] = miss(frq,0);
  i = i + 1;
endo;

_pscreen = 1;

graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,1);
  makewind(9/2,6.855/2,0,0,1);
  makewind(9/2,6.855/2,9/2,0,1);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6; _plwidth = 10;
  _paxht = 0.25; _pnumht = 0.18; _ptitlht = 0.25;

  xlabel("\216Perte");
  xtics(-500,4000,500,5);
  ytics(0,35,5,5);

  setwind(1);
    title("\216Distribution discrete");
    _pbartyp = 6~2;
    _pbarwid = 0.5;
    _pmsgstr = "\45";
    _pmsgctl = 5.9~6.50~0.08~-40~2~0~5;
    bar(hist_x[.,1],hist_y[.,1]);

    _pmsgctl = 0;

  setwind(2);
    title("\216LGD = 50%");
    _pbartyp = 6 ~ 1;
    bar(hist_x[.,2],hist_y[.,2]);

  setwind(3);
    title("\216Distribution Beta");
    _pbartyp = 6 ~ 4;
    _pmsgstr = "\201^";
    _pmsgctl = 5.52~6.28~0.225~0~2~0~6;
    bar(hist_x[.,3],hist_y[.,3]);

    graphprt("-c=1 -cf=param20.eps");

  endwind;
