new;
library gdr,pgraph,optmum;
gdrSet;

let lgd = 68 90 22 45 17 25 89 65 75 56 87 92 46;
lgd = lgd / 100;
mu = meanc(lgd);
sigma = stdc(lgd);

{a1,b1} = calibrateBeta(mu,sigma);

proc mlProc(theta);
  local a,b,logl;
  theta = sqrt(theta^2);
  a = theta[1];
  b = theta[2];
  logl = ln( pdfbeta(LGD,a,b) );
  retp(-sumc(logl));
endp;

sv = a1|b1;
{theta,grd,fmin,retcode} = optmum(&mlProc,sv);
theta = sqrt(theta^2);
a2 = theta[1];
b2 = theta[2];

x = seqa(0,1/1000,1001);
pdf1 = pdfBeta(x,a1,b1);
pdf2 = pdfBeta(x,a2,b2);


graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  setwind(1);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1; _plwidth = 10; _pcolor = 1|4;
  fonts("simplex simgrma");
  xtics(0,1,0.2,2);
  ytics(0,2.0,0.5,5);
  xlabel("\216LGD");
  _plegstr = "Methode des moments\000Maximum de vraisemblance";
  _plegctl = {2 4 1.5 5.5};
  graphprt("-c=1 -cf=param18.eps");
  xy(x,pdf1~pdf2);

  setwind(2);
    xlabel(""); _paxes = 0;
  _pmsgstr = "\202\39\201";
  _pmsgctl = 2.42~5.90~0.10~0~2~0~4 ;
  draw;

  endwind;