new;
library gdr,pgraph;
gdrSet;

cls;

rndseed 6;

I = 1000;
Ni = 1000;
N = I * Ni;
Maturity = 10;
dt = 0.25;

lambda = 6/1e4;
let alpha = 0.05 0.25 0.70;
let s = 100 50 5;
s = s / 1e4;

u = rndu(I,1);
tau = -ln(u)./lambda;
tau = delif(tau,tau .> Maturity);
e = ones(rows(tau),1);
Losses = Ni * e .* (0.5 + 0.5*rndu(rows(tau),1));
  
{t,L_t,FixedLeg,FloatingLeg} = CDO_Legs(tau,Losses,s,alpha,N,Maturity,dt);

print sumc(FixedLeg)~sumc(FloatingLeg);

graphset;
  begwind:
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pnumht = 0.225; _paxht = 0.25; _ptitlht = 0.25;
  xlabel("\216t");
  fonts("simplex simgrma");
  _plwidth = 10; _pysci = 1;

  setwind(1);
    title("\216L]i[(\202t\201]i[)");
    xtics(0,Maturity,2,8); 
    ytics(0,I,I/5,5); 
    _pline = e.*(1~6)~tau~e.*0~tau~Losses~e.*(1~0~10);
    draw;

  setwind(2);
    title("\216L(t)");
    _plwidth = 10; _pltype = 6; _pcolor = 2;
    ytics(0,5000,1000,2);
    e = ones(rows(alpha),1);
    _pline = e.*(1~3~0)~cumsumc(N*alpha)~10*e~cumsumc(N*alpha)~e.*(1~0~10);  
    {px,py} = PiecewiseConstantFunctionGraph(0,0,t,cumsumc(L_t),error(0),error(0)); 
    xy(px,py);

  _pysci = 5;

  indx = 1;
  setwind(2+indx); 
    title("\216Tranche equity");
    ytics(0,125,25,5); 
    e = ones(rows(t),1);
    _pline = e.*(1~6)~t~e.*0~t~FixedLeg[.,indx]~e.*(1~1~10) ;
    xy(seqa(0,1,Maturity+1),zeros(Maturity+1,1));

  indx = 2;
  setwind(2+indx); 
    title("\216Tranche mezzanine");
    ytics(0,400,100,5); 
    _pline = e.*(1~6)~t~e.*0~t~FixedLeg[.,indx]~e.*(1~4~10);
    xy(seqa(0,1,Maturity+1),zeros(Maturity+1,1));

    graphprt("-c=1 -cf=credit9.eps");

  endwind;
  

 
  

