new;
library gdr,pgraph;
gdrSet;

declare matrix lambda;

load tableDF[18,2] = df.dat;
tableDF[.,1] = tableDF[.,1] / 365;

let StartDate = 2002 01 01;
let Maturity = 10;
let AccrualDate = 2003 02 15;

Coupon = 4.5;
Nominal = 100;

{dt,dt_cc} = BondCalendar(StartDate,Maturity,AccrualDate);
CC = Coupon * dt_cc/365;

tableCoupon = packr(dt/365 ~ Coupon * ones(Maturity,1));
MaturityDate = tableCoupon[rows(tableCoupon),1];

fn SurvFn(t) = exp(-lambda*t);
fn DensFn(t) = lambda * exp(-lambda*t);

ns = 1000000;
let alpha = 0.95 0.99 0.999;

let RecoveryRate_ = 0 0 50 0 50;
RecoveryRate_ = RecoveryRate_ / 100;
let lambda_ = 1e-20 50 50 200 200;
lambda_ = lambda_ / 1e4;

VaR = zeros(rows(alpha),5);
_intord = 1000;

i = 1;
do until i > 5;
  rndseed 123;
  RecoveryRate = RecoveryRate_[i];
  lambda = lambda_[i];
  DirtyPrice = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,RecoveryRate,&SurvFn,&DensFn);
  tau = -ln(rndu(ns,1))/lambda;
  Dm = tableCoupon[.,1] .< tau';
  D = MaturityDate .< tau;
  Loss = DirtyPrice - (sumc(curveDF(tableDF,tableCoupon[.,1]) .* Dm .* tableCoupon[.,2])
               +  curveDF(tableDF,MaturityDate) .* D * Nominal 
               + (1-D) .* Nominal .* RecoveryRate .* curveDF(tableDF,tau)); 
  VaR[.,i] = quantile(Loss,alpha);
  print meanc(Loss);
  i = i + 1;
endo;

output file = credit6.out reset;

call printfmt2(VaR,1,2);

output off;
