new;
library gdr,pgraph;
gdrSet;

declare matrix lambda;

load tableDF[18,2] = df.dat;
tableDF[.,1] = tableDF[.,1] / 365;

let StartDate = 2002 01 01;
let Maturity = 10;
let AccrualDate = 2003 02 15;

Coupon = 4.5;
Nominal = 100;

{dt,dt_cc} = BondCalendar(StartDate,Maturity,AccrualDate);
CC = Coupon * dt_cc/365;

tableCoupon = packr(dt/365 ~ Coupon * ones(Maturity,1));
MaturityDate = tableCoupon[rows(tableCoupon),1];

fn SurvFn(t) = exp(-lambda*t);
fn DensFn(t) = lambda * exp(-lambda*t);


lambda = 0;
DirtyPrice = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              0,&SurvFn,&DensFn);
Yield0 = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice);

RecoveryRate = seqa(0,0.01,101);
Yield = zeros(101,1);

lambda = 10/1e4;
DirtyPrice = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                         RecoveryRate,&SurvFn,&DensFn);
i = 1;
do until i > 101;
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread1 = Yield - Yield0;

lambda = 100/1e4;
DirtyPrice = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                         RecoveryRate,&SurvFn,&DensFn);
i = 1;
do until i > 101;
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread2 = Yield - Yield0;

lambda = 200/1e4;
DirtyPrice = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                         RecoveryRate,&SurvFn,&DensFn);
i = 1;
do until i > 101;
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread3 = Yield - Yield0;

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  fonts("simplex simgrma");
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 2|1|4;
  xtics(0,100,20,2);
  ytics(-25,200,25,2);
  xlabel("\216Taux de recouvrement (en %)");
  ylabel("\216Spread (en pb)");
  _plegstr = "\202l\201 = 0 pb\000\202l\201 = 100 pb\000\202l\201 = 200 pb";
  _plegctl = {2 5 5 4};
  graphprt("-c=1 -cf=credit5.eps");  
  xy(1e2*RecoveryRate,1e4*(Spread1~Spread2~Spread3));