new;
library gdr,pgraph;
gdrSet;

declare matrix lambda;

load tableDF[18,2] = df.dat;
tableDF[.,1] = tableDF[.,1] / 365;

let StartDate = 2002 01 01;
let Maturity = 10;
let AccrualDate = 2003 02 15;

Coupon = 4.5;
Nominal = 100;

{dt,dt_cc} = BondCalendar(StartDate,Maturity,AccrualDate);
CC = Coupon * dt_cc/365;

tableCoupon = packr(dt/365 ~ Coupon * ones(Maturity,1));
MaturityDate = tableCoupon[rows(tableCoupon),1];

fn SurvFn(t) = exp(-lambda*t);
fn DensFn(t) = lambda * exp(-lambda*t);

n = 201;
lambdaTable = seqa(0,10,n)/1e4;
DirtyPrice = zeros(n,1);
Yield = zeros(n,1);

RecoveryRate = 0;
i = 1;
do until i > rows(lambdaTable);
  lambda = lambdaTable[i];
  DirtyPrice[i] = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              RecoveryRate,&SurvFn,&DensFn);
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread1 = Yield - Yield[1];

RecoveryRate = 0.30;
i = 1;
do until i > rows(lambdaTable);
  lambda = lambdaTable[i];
  DirtyPrice[i] = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              RecoveryRate,&SurvFn,&DensFn);
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread2 = Yield - Yield[1];

RecoveryRate = 0.60;
i = 1;
do until i > rows(lambdaTable);
  lambda = lambdaTable[i];
  DirtyPrice[i] = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              RecoveryRate,&SurvFn,&DensFn);
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;
Spread3 = Yield - Yield[1];

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  fonts("simplex simgrma");
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 2|1|4;
  xtics(0,2000,250,2);
  ytics(0,2000,250,2);
  xlabel("\216\202l\201 (en pb)");
  ylabel("\216Spread (en pb)");
  _plegstr = "Taux de recouvrement = 0%\000Taux de recouvrement = 30%\000Taux de recouvrement = 60%";
  _plegctl = {2 5 2 5};
  graphprt("-c=1 -cf=credit4.eps");
  xy(1e4*lambdaTable,1e4*(Spread1~Spread2~spread3));

