new;
library gdr,pgraph;
gdrSet;

declare matrix lambda;

load tableDF[18,2] = df.dat;
tableDF[.,1] = tableDF[.,1] / 365;

let StartDate = 2002 01 01;
let Maturity = 10;
let AccrualDate = 2003 02 15;

Coupon = 4.5;
Nominal = 100;

{dt,dt_cc} = BondCalendar(StartDate,Maturity,AccrualDate);
CC = Coupon * dt_cc/365;

tableCoupon = packr(dt/365 ~ Coupon * ones(Maturity,1));
MaturityDate = tableCoupon[rows(tableCoupon),1];

fn SurvFn(t) = exp(-lambda*t);
fn DensFn(t) = lambda * exp(-lambda*t);

let lambdaTable = 0 10 10 100 100 1000 1000 1000;
lambdaTable = lambdaTable / 1e4;
let RecoveryRate = 0 0 50 0 50 0 50 100;
RecoveryRate = RecoveryRate / 100;
DirtyPrice = zeros(rows(lambdaTable),1);
Yield = zeros(rows(lambdaTable),1);

_intord = 1000;
i = 1;
do until i > rows(lambdaTable);
  lambda = lambdaTable[i];
  DirtyPrice[i] = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              RecoveryRate[i],&SurvFn,&DensFn);
  Yield[i] = YTM(tableCoupon,MaturityDate,Nominal,DirtyPrice[i]);
  i = i + 1;
endo;

Spread = Yield - Yield[1];
PD = 1 - exp(-lambdaTable); 

output file = credit3.out reset;

call printfmt2(100*PD~1e4*lambdaTable~100*RecoveryRate~DirtyPrice~100*Yield~1e4*Spread,1,2|0|0|2|2|0);

output off;