new;
library gdr,pgraph;
gdrSet;

declare matrix lambda;

r0 = 0.05;
tableDF = 30~exp(-r0*30);

Coupon = 4.5;
Nominal = 100;

fn SurvFn(t) = exp(-lambda*t);
fn DensFn(t) = lambda * exp(-lambda*t);

let StartDate = 2002 01 01;
let Maturity = 10;
tableCoupon = seqa(1,1,10) ~ Coupon * ones(Maturity,1);
MaturityDate = tableCoupon[rows(tableCoupon),1];

Recovery_Rate = 0.50;

lambda = 0.00;
P0 = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              Recovery_Rate,&SurvFn,&DensFn);
P1 = sumc(tableCoupon[.,2] .* exp(-r0 .* tableCoupon[.,1])) + Nominal .* exp(-r0 .* MaturityDate);
print P0~P1;

lambda = 0.02;
P0 = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              Recovery_Rate,&SurvFn,&DensFn);
P1 = sumc(tableCoupon[.,2] .* exp(-(r0+lambda) .* tableCoupon[.,1])) + Nominal .* exp(-(r0+lambda) .* MaturityDate) +
(1 - Recovery_Rate) .* Nominal .* lambda ./ (r0 + lambda) .* (1 - exp(-(r0+lambda) .* MaturityDate));
print P0~P1;

lambda = 0.10;
P0 = BondPricing(tableDF,tableCoupon,MaturityDate,Nominal,
                              Recovery_Rate,&SurvFn,&DensFn);
P1 = sumc(tableCoupon[.,2] .* exp(-(r0+lambda) .* tableCoupon[.,1])) + Nominal .* exp(-(r0+lambda) .* MaturityDate) +
(1 - Recovery_Rate) .* Nominal .* lambda ./ (r0 + lambda) .* (1 - exp(-(r0+lambda) .* MaturityDate));
print P0~P1;



