new;
library gdr,pgraph,optmum;
gdrSet;

declare matrix r = 0.05;
declare matrix rho,N,order,lambda;

proc density_n(t);
  retp( lambda .* exp(-lambda.*t) );
endp;

proc cdf_n(t);
  retp( 1-exp(-lambda.*t) );
endp;

proc computeRho(rho,N);
  retp( diagrv(rho*ones(N,N),ones(N,1)) );
endp;  

proc cdfCopula(S);
  retp( cdfCopulaNormal(S,computeRho(rho,N)) );
endp;

proc _order_alpha(k,n);
  local alpha,l;

  alpha = 0;
  l = n;
  do until l > k;
    alpha = alpha + (-1)^(k-l) .* k! ./ (k-l)! ./ l! ;
    l = l + 1;
  endo;

  retp(alpha);
endp;

proc Combinations(n,r);
  local nComb,xComb,tal,Level2,i2,j2,tal2,n2,r2,xComb2;
  nComb = round(  exp(  ln( prodc(seqa(n,-1,r)) ) - lnfact(r)  )  );
  xComb = miss( zeros(nComb,r),0 );  
  tal = {};
  {j2,xComb2} = CombNextLevel(1,1,1,tal,n,r,xComb);  
  retp(xComb2);
endp;

proc (2) = CombNextLevel(Level,i,j,tal,n,r,xComb);
  local Level2,i2,tal2,n2,r2;
  if Level <= r;
    do until i > (n-r+Level);
      { j,xComb } =  CombNextLevel( Level+1,i+1,j,tal~i,n,r,xComb );
      i = i + 1;            
    endo;                   
  else;                     
    xComb[j,.] = tal;
    j = j + 1;
    retp( j,xComb );
  endif;
  retp( j,xComb );
endp;

proc cdfOrderStatistic(&cdfCopula,cdfs,t,n);
  local cdfCopula:proc;
  local NN,x,e,cdf,k,cb,alpha,j,u;

  NN = rows(cdfs);
  x = zeros(rows(t),NN);
  j = 1;
  do until j > NN;
    local cdfProc;
    cdfProc = cdfs[j];
    local cdfProc:proc;
    x[.,j] = cdfProc(t);
    j = j + 1;
  endo;

  e = ones(rows(t),NN);
  cdf = 0;

  k = n;
  do until k > NN;
    cb = Combinations(NN,k);
    alpha = _order_alpha(k,n);
    j = 1;
    do until j > rows(cb);
      u = e;   
      u[.,cb[j,.]] = submat(x,0,cb[j,.]);
      cdf = cdf + alpha .* cdfCopula(u);      
      j = j + 1;
    endo;
    k = k + 1;
  endo;

  retp(cdf);
endp;

proc cdf_order(t);

  if N == 1;
    retp( cdf_n(t) ); 
  else;
    retp( cdfOrderStatistic(&cdfCopula,&cdf_n.*ones(N,1),t,order) );
  endif;

endp;

proc payoff(t);
  local pdf_tau;

  pdf_tau = gradp1D(&cdf_order,t);

  retp( exp(-r.*t) .* pdf_tau );
endp;

proc _Compute_Quadrature(&f,xl,order);
  local f:proc,diff,e,w,xc,fx;

  _quad_poly = 1;
  _quad_order = order;

  {e,w} = _quadrature;

  diff = xl[1] - xl[2];
  xc = 0.5*( (xl[2]+xl[1]) + (diff .* e));
  fx = f(xc);
  fx = ((diff/2).* (w'fx));
  retp(fx);
endp;

proc Compute_Price(t);
  local Price,i;

  Price = zeros(rows(t),1);

  i = 1;
  do until i > rows(t);
    Price[i] = _Compute_Quadrature(&payoff,t[i]|0,128);
    i = i + 1;
  endo;

  retp(Price);
endp;

lambda = 0.05;
t = 1;
N_max = 5;

rhoVector = seqa(0,0.99/25,25)|0.99;
nRho = rows(rhoVector);
price1 = zeros(nRho,1);
price2 = zeros(nRho,1);
price3 = zeros(nRho,1);
price4 = zeros(nRho,1);
price5 = zeros(nRho,1);

N = 1;
do until N > N_max;
  Price = zeros(rows(rhoVector),N);
  order = 1;
  do until order > N;
    t0 = hsec;
    i = 1;
    do until i > nRho;
      rho = rhoVector[i];
      Price[i,order] = Compute_Price(t);
      dt = (nRho-i)*(hsec - t0)/i;
      print /flush ftos(N,"N = %lf",1,0)$+ftos(order," / order = %lf",1,0)$+ftos(100*rho," / rho = %lf",1,0)$+" / "$+etstr(dt);
      i = i + 1;
    endo;
    order = order + 1;
  endo;
  call varput(Price,ftos(N,"Price%lf",1,0));
  fileName = ftos(N,"Price%lf",1,0);
  save ^fileName = Price;
  N = N + 1;
endo;

save Price1,Price2,Price3,Price4,Price5;

loadm Price1,Price2,Price3,Price4,Price5;

R = 0.40;
Nominal = 1e6;
JV1 = (1 - R) * Nominal * Price1;
JV2 = (1 - R) * Nominal * Price2;
JV3 = (1 - R) * Nominal * Price3;
JV4 = (1 - R) * Nominal * Price4;
JV5 = (1 - R) * Nominal * Price5;

w = ones(nRho,1);
w[nRho] = 10;

N = 1;
do until N > N_max;
  JV = varget(ftos(N,"JV%lf",1,0));
  JV[rows(rhoVector),.] = JV1[rows(rhoVector),1] * ones(1,N);
  order = 1;
  do until order > N;
    JV[.,order] = fspline(csspline(rhoVector,JV[.,order],w,0.99999),rhoVector);
    order = order + 1;
  endo;
  call varput(JV,ftos(N,"JV%lf",1,0));
  N = N + 1;
endo;

graphset;
  begwind;
  window(2,2,0);
  fonts("simplex simgrma");

  _pdate = ""; _pnum = 2; _pframe = 0; _pysci = 1;
  _paxht = 0.22; _pnumht = 0.20; _ptitlht = 0.25;
  _pltype = 6|1|3|6|5; _plwidth = 10; _pcolor = 1|2|3|4|5;
  _pstype = 8|8|8|8|9; _psymsiz = 5.5;
  _plctrl = 0|0|0|4|4;

  xtics(0,100,20,2);
  xlabel("\216\202r\201 (en %)");
  ytics(0,1.4e5,0.2e5,5);

  _pline = 1~6~0~JV1[1]~100~JV1[1]~1~0~10;
  _psym = 99~JV1[rows(rhoVector),1]~8~4~0~1~10;

  setwind(1);
    title("\216I = 2");
    xy(100*rhoVector,JV2);

  setwind(2);
    title("\216I = 3");
    xy(100*rhoVector,JV3);
 
  setwind(3);
    title("\216I = 4");
    xy(100*rhoVector,JV4);

  setwind(4);
    title("\216I = 5");
    _plegstr = "n = 1\000n = 2\000n = 3\000n = 4\000n = 5";
    _plegctl = {2 6 -3 10};
    xy(100*rhoVector,JV5);

    graphprt("-c=1 -cf=credit19.eps");

  endwind;
