new;
library gdr,optmum,pgraph;
gdrSet;

declare matrix r = 0.05;
declare matrix rho,N,lambda;

proc density_n(t);
  retp( lambda .* exp(-lambda.*t) );
endp;

proc Survival_n(t);
  retp( exp(-lambda.*t) );
endp;

proc computeRho(rho,N);
  retp( diagrv(rho*ones(N,N),ones(N,1)) );
endp;  

proc Survival_tau(t);
  local S;

  S = survival_n(t);

  if N == 1;
    retp(S);
  elseif N == 2;
    retp( cdfCopulaNormal2(S[.,1],S[.,2],rho) );
  else;
    retp( cdfCopulaNormal(S,computeRho(rho,N)) );
  endif;
endp;

proc payoff(t);
  local pdf_tau;

  pdf_tau = -gradp1D(&Survival_tau,t);

  retp( exp(-r.*t) .* pdf_tau );
endp;

proc _Compute_Quadrature(&f,xl,order);
  local f:proc,diff,e,w,xc,fx;

  _quad_poly = 1;
  _quad_order = order;

  {e,w} = _quadrature;

  diff = xl[1] - xl[2];
  xc = 0.5*( (xl[2]+xl[1]) + (diff .* e));
  fx = f(xc);
  fx = ((diff/2).* (w'fx));
  retp(fx);
endp;

proc Compute_Price(t);
  local Price,i;

  Price = zeros(rows(t),1);

  i = 1;
  do until i > rows(t);
    Price[i] = _Compute_Quadrature(&payoff,t[i]|0,128);
    i = i + 1;
  endo;

  retp(Price);
endp;

t = 1;

N_max = 5;
rhoVector = seqa(0,0.99/25,25)|0.99;
nRho = rows(rhoVector);
price = zeros(nRho,N_max);

i = 1;
do until i > nRho;
  rho = rhoVector[i];

  N = 1;
  do until N > N_max;
    lambda = 0.05 * ones(1,N);
    Price[i,N] = Compute_Price(t);
    N = N + 1;
  endo;

  i = i + 1;
endo;

R = 0.40;
Nominal = 1e6;
JV = (1 - R) * Nominal * Price;

JV[nRho,.] = JV[nRho,1] * ones(1,N_max);
w = ones(nRho,1);
w[nRho] = 10;

i = 2;
do until i > N_max;
  JV[.,i] = fspline(csspline(rhoVector,JV[.,i],w,0.9999),rhoVector);
  i = i + 1;
endo;

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0; _pysci = 1;
  fonts("simplex simgrma");
  _pltype = 6|1|3|6|5; _plwidth = 10; _pcolor = 1|2|3|4|5;
  _pstype = 8|8|8|8|9; _psymsiz = 4.5;
  _plctrl = 0|0|0|4|4;

  xtics(0,100,20,2);
  xlabel("\216\202r\201 (en %)");
  ytics(0,1.4e5,0.2e5,5);

  _plegstr = "I = 1\000I = 2\000I = 3\000I = 4\000I = 5";
  _plegctl = {2 5 6 5};

  _psym = 99~JV[rows(rhoVector),1]~8~4~0~1~10;

  graphprt("-c=1 -cf=credit18.eps");

  xy(100*rhoVector,JV);