new;
library gdr,pgraph,optmum;
gdrSet;

declare matrix lambda;

load zcTable[18,2] = df.dat;
zcTable[.,1] = zcTable[.,1] / 365;

let lambdaTable[1,2] = 30 0.0050;

_intord = 128;

Nominal = 1e6;
Recovery = 0.40;
let T = 0.5 1 2 3 5 7 10;
nT = rows(T);

CDS = zeros(nT,2);
ATM = zeros(nT,2);

Margin = 10/1e4;
i = 1;
do until i > nT;
  Maturity = T[i];
  Tm = seqa(0.25,0.25,4*Maturity);
  {CDS[i,1],ATM[i,1]} = CDS_Pricing(zcTable,lambdaTable,Nominal,Recovery,Margin,Maturity,Tm);
  i = i + 1;
endo;

Margin = 100/1e4;
i = 1;
do until i > rows(T);
  Maturity = T[i];
  Tm = seqa(0.25,0.25,4*Maturity);
  {CDS[i,2],ATM[i,2]} = CDS_Pricing(zcTable,lambdaTable,Nominal,Recovery,Margin,Maturity,Tm);
  i = i + 1;
endo;

ATM = 1e4*ATM;

output file = credit13.out reset;

print ftosa(CDS,"%lf",4,0)$~ftosa(ATM[.,1],"%lf",2,1);

output off;