new;
library gdr,pgraph;
gdrSet;

external matrix _localQuantile_weight;

fileName = "portfolio-1";
load data = ^fileName;
EaD = data[.,3];
Spread1Y = data[.,7];
rating = data[.,8];
let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;
Spread = (Euribor + Spread) / 1e4;
ExReturn0 = sumc(EaD .* Spread);

fileName = "cpm2";
datName = fileName $+ "-cpm-portfolio-loss";
cpmLoss = loadd(datName);
datName = fileName $+ "-cpm-loan-loss";
loans = seqa(1,20,25);
cpmLoans = loadd(datName)';
nLoans = rows(loans);
X0 = EaD[Loans];
LoanSpread = Spread[loans];
LoanReturn0 = sumc(X0 .* LoanSpread);

_RiskMeasure = 1;
alpha = 0.999;
_localQuantile_Bandwidth = 50;
_localQuantile_mtd = 2;
{Risk0,DR0,cRC0} = CreditVaR_RiskContribution(fileName,alpha);

proc (3) = computeRiskReturn(X);
  local Li,L,Risk,indx,p,cRc,DR,LoanReturn,ExReturn;

  Li = X .* cpmLoans ./ X0;
  L = cpmLoss + sumc(Li);
  Risk = localQuantile(L,alpha);
  indx = _localQuantile_weight[.,1];
  p = _localQuantile_weight[.,2];
 
  cRC = sumc( p .* Li[.,indx]');
  DR = cRC ./ X;

  LoanReturn = sumc(X .* LoanSpread);
  ExReturn = (ExReturn0 - LoanReturn0) + LoanReturn;

  retp(Risk,DR,ExReturn);
endp;

nIters = 1;
theta = seqa(-0.1,0.025,20);

x = zeros(nLoans,nIters+1);
Risk = miss(zeros(nIters+1,rows(theta)),0);
exReturn = miss(zeros(nIters+1,rows(theta)),0);
path = zeros(rows(theta),2);

x[.,1] = x0;
Risk[1,.] = Risk0 * ones(1,rows(theta));
exReturn[1,.] = exReturn0 * ones(1,rows(theta));

_CO_A = ones(1,25);
_CO_B = 25000;
_co_Bounds = {0 25000};
_CO_C = LoanSpread';

j = 1;
do until j > rows(theta);
  _co_D = (1+theta[j]) * LoanReturn0;

  i = 1;
  do until i > nIters;

    {VaR,DR,RM} = computeRiskReturn(x[.,i]);
  
    {xi,u1,u2,u3,u4,ret } = QProg(x[.,i],zeros(nLoans,nLoans),-DR,_CO_A,_CO_B,_CO_C,_CO_D,_CO_bounds);
    if ismiss(xi);
      xi = x[.,i];
      break;
    endif;

    x[.,i+1] = xi;

    {VaR,DR,RM} = computeRiskReturn(x[.,i+1]);

    Risk[i+1,j] = VaR;
    exReturn[i+1,j] = RM;
 
    i = i + 1;
  endo;

  path[j,.] = VaR~RM;

  print /flush j;
  j = j + 1;
endo;

tmp = path;
save cpm46 = tmp;

load tmp = cpm46;
path = tmp;

Risk_X0 = Risk0;
exReturn_X0 = exReturn0;

load RiskReturn = cpm41;
RiskReturn[.,2] = RiskReturn[.,2] ./ 1e4;

Risk0 = RiskReturn[1,1];
exReturn0 = RiskReturn[1,2];
Risk = RiskReturn[.,1]; 
exReturn = RiskReturn[.,2];

load ch = cpm43;

y_min = minc(ch[.,2]);
y_max = maxc(ch[.,2]);
y = seqa(y_min,(y_max-y_min)/100,101);
x = fspline(csspline(ch[.,2],ch[.,1],1,0.90),y);

rndseed 123;
n = rows(Risk);
cpt = 1;
indx = miss(zeros(n,1),0);
indx[1] = 1;
s_x = 5;
s_y = 1;
d0 = 20;
i = 1;
do until i > n;  
  tmp = indx[1:cpt];
  m_x = risk[tmp]; m_y = exReturn[tmp];
  d = minc(sqrt( ((risk[i] - m_x)/s_x)^2 + ((exReturn[i] - m_y)/s_y)^2));
  if d > d0;
    cpt = cpt + 1;
    indx[cpt] = i;
  endif;
  i = i + 1;
endo;

indx = indx[1:cpt];

graphset;
  fonts("simplex simgrma complex");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = -1; _psymsiz = 2.5; _pstype = 4; _pcolor = 2;
  e = ones(rows(path),1);
  _psym = ch[.,1]~ch[.,2]~ones(rows(ch),1).*(8~4~1~1~0) |
          path~e.*(8~4~0~1~0);
  _pline = e.*(1~6~Risk_X0~exReturn_X0)~path~e.*(1~0~7);
  plineConnectPoints(x~y);
  xlabel("\216VaR");
  ylabel("\216Rendement");
  xtics(0.88e5,1.04e5,0.02e5,5);
  ytics(3.8e4,4.10e4,0.05e4,5);
  _pmsgstr = "Frontiere efficiente";
  _pmsgctl = 0.91e5~3.95e4~0.175~30~1~1~10;
  _pmsgstr = _pmsgstr $+ "\000\203\45\201";
  _pmsgctl = _pmsgctl | 3.09~4.29~0.07~-20~2~1~6;
  graphprt("-c=1 -cf=cpm46.eps");
  xy(Risk[indx],exReturn[indx]);


