new;
library gdr,pgraph,co;
gdrSet;

external matrix _localQuantile_weight;
declare matrix _Deriv;

fileName = "portfolio-1";
load data = ^fileName;
EaD = data[.,3];
Spread1Y = data[.,7];
rating = data[.,8];
let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;
Spread = (Euribor + Spread) / 1e4;
ExReturn0 = sumc(EaD .* Spread);

fileName = "cpm2";
datName = fileName $+ "-cpm-portfolio-loss";
cpmLoss = loadd(datName);
datName = fileName $+ "-cpm-loan-loss";
loans = seqa(1,20,25);
cpmLoans = loadd(datName)';
nLoans = rows(loans);
X0 = EaD[Loans];
LoanSpread = Spread[loans];
LoanReturn = sumc(X0 .* LoanSpread);

_RiskMeasure = 1;
alpha = 0.999;
_localQuantile_Bandwidth = 50;
_localQuantile_mtd = 2;
{VaR0,DR0,cRC0} = CreditVaR_RiskContribution(fileName,alpha);

proc (3) = VaR_and_DR(X);
  local Li,L,VaR,indx,p,cRc,DR;

  Li = X .* cpmLoans ./ X0;
  L = cpmLoss + sumc(Li);
  VaR = localQuantile(L,alpha);
  indx = _localQuantile_weight[.,1];
  p = _localQuantile_weight[.,2];
 
  cRC = sumc( p .* Li[.,indx]');
  DR = cRC ./ X;

  retp(VaR,DR,cRC);
endp;

proc (1) = MinVaR(X);
  local VaR,DR,cRC;

  {VaR,DR,cRC} = VaR_and_DR(X);
   _Deriv = DR;

  retp( VaR );
endp;

fn GradVaR(X) = _Deriv;

_CO_A = ones(1,25);
_CO_B = 25000;
_co_Bounds = {0 25000};
_CO_C = LoanSpread';

_co_Algorithm = 3;
_co_GradProc = &GradVaR;
_co_DirTol = 1e-10;

target = 38000;
_co_D = target-(ExReturn0-LoanReturn);

sv = rndu(25,1);
sv = sv * 25000 / sumc(sv);

/*
{x,f,g,retcode} = co(&MinVaR,sv);
save cpm45 = x;
*/

load x = cpm45;

/*
Risk_X = MinVaR(X);
Li = X .* cpmLoans ./ X0;
L = cpmLoss + sumc(Li);
Risk_X = quantile(L,alpha);
ExReturn_X = x'LoanSpread + (ExReturn0-LoanReturn);
*/

load RiskReturn = cpm41;
RiskReturn[.,2] = RiskReturn[.,2] ./ 1e4;

Risk0 = RiskReturn[1,1];
exReturn0 = RiskReturn[1,2];
Risk = RiskReturn[.,1]; 
exReturn = RiskReturn[.,2];

Risk_X = 0.985*Risk0;
ExReturn_X = 38700;

loadm ch = cpm43;

y_min = minc(ch[.,2]);
y_max = maxc(ch[.,2]);
y = seqa(y_min,(y_max-y_min)/100,101);
x = fspline(csspline(ch[.,2],ch[.,1],1,0.90),y);

rndseed 123;
n = rows(Risk);
cpt = 1;
indx = miss(zeros(n,1),0);
indx[1] = 1;
s_x = 5;
s_y = 1;
d0 = 20;
i = 1;
do until i > n;  
  tmp = indx[1:cpt];
  m_x = risk[tmp]; m_y = exReturn[tmp];
  d = minc(sqrt( ((risk[i] - m_x)/s_x)^2 + ((exReturn[i] - m_y)/s_y)^2));
  if d > d0;
    cpt = cpt + 1;
    indx[cpt] = i;
  endif;
  i = i + 1;
endo;

indx = indx[1:cpt];

graphset;
  fonts("simplex simgrma complex");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = -1; _psymsiz = 2.5; _pstype = 4; _pcolor = 2;
  _psym = Risk0~ExReturn0~11~5~0~1~8 |
          ch[.,1]~ch[.,2]~ones(rows(ch),1).*(8~4~1~1~0) |
          0.990*Risk_X~ExReturn_X~11~5~0~1~8 ;
  plineConnectPoints(x~y);
  xlabel("\216VaR");
  ylabel("\216Rendement");
  xtics(0.88e5,1.04e5,0.02e5,5);
  ytics(3.8e4,4.10e4,0.05e4,5);
  _pmsgstr = "Portefeuille original\000Frontiere efficiente\000Portefeuille optimise";
  _pmsgctl = 1.005*Risk0~exReturn0~0.175~0~1~0~12 | 
             0.91e5~3.95e4~0.175~30~1~1~10 |
             0.995*Risk_X~0.997*exReturn_X~0.165~0~1~0~12;
  _pmsgstr = _pmsgstr $+ "\000\203\45\201";
  _pmsgctl = _pmsgctl | 3.09~4.29~0.07~-20~2~1~6;
  _pmsgstr = _pmsgstr $+ "\000\202\39\201";
  _pmsgctl = _pmsgctl | 5.20~2.00~0.17~0~2~0~10;
  graphprt("-c=1 -cf=cpm45.eps");
  xy(Risk[indx],exReturn[indx]);

