new;
library gdr,pgraph;
gdrSet;

load RiskReturn = cpm41;
RiskReturn[.,2] = RiskReturn[.,2] ./ 1e4;

Risk0 = RiskReturn[1,1];
exReturn0 = RiskReturn[1,2];
Risk = RiskReturn[.,1]; 
exReturn = RiskReturn[.,2];

indx_ch = ConvexHull(RiskReturn[.,2 1]);
ch = RiskReturn[indx_ch,.];
nCH = rows(ch);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = -1; _psymsiz = 0.5; _pstype = 4; _pcolor = 2;
  _psym = Risk0~exReturn0~11~5~4~1~0;
  _psym = _psym | ch~ones(nCH,1) .* (8~5~4~1~10);
  _pmsgstr = MakeMsgStr(ftocv(seqa(1,1,nCH),1,0));
  _pmsgctl = ch~ones(nCH,1) .* (0.15~0~1~0~10);
  plineConnectPoints(ch);  
  xy(Risk,exReturn);

indx = seqa(6,1,10);
indx_ch = indx_ch[indx];
ch = ch[indx,.];

save cpm43 = ch;

y_min = minc(ch[.,2]);
y_max = maxc(ch[.,2]);
y = seqa(y_min,(y_max-y_min)/100,101);
x = fspline(csspline(ch[.,2],ch[.,1],1,0.90),y);

rndseed 123;
n = rows(Risk);
cpt = 1;
indx = miss(zeros(n,1),0);
indx[1] = 1;
s_x = 5;
s_y = 1;
d0 = 20;
i = 1;
do until i > n;  
  tmp = indx[1:cpt];
  m_x = risk[tmp]; m_y = exReturn[tmp];
  d = minc(sqrt( ((risk[i] - m_x)/s_x)^2 + ((exReturn[i] - m_y)/s_y)^2));
  if d > d0;
    cpt = cpt + 1;
    indx[cpt] = i;
  endif;
  i = i + 1;
endo;

indx = indx[1:cpt];

graphset;
  fonts("simplex simgrma complex");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _plctrl = -1; _psymsiz = 2.5; _pstype = 4; _pcolor = 2;
  _psym = Risk0~ExReturn0~11~5~0~1~8 |
          ch[.,1]~ch[.,2]~ones(rows(ch),1).*(8~4~1~1~0);
  plineConnectPoints(x~y);
  xlabel("\216VaR");
  ylabel("\216Rendement");
  xtics(0.88e5,1.04e5,0.02e5,5);
  ytics(3.8e4,4.10e4,0.05e4,5);
  _pmsgstr = "Portefeuille original\000Frontiere efficiente";
  _pmsgctl = 1.005*Risk0~exReturn0~0.175~0~1~0~12 | 
             0.91e5~3.95e4~0.175~30~1~1~10;
  _pmsgstr = _pmsgstr $+ "\000\203\45\201";
  _pmsgctl = _pmsgctl | 3.09~4.29~0.07~-20~2~1~6;
  graphprt("-c=1 -cf=cpm43.eps");
  xy(Risk[indx],exReturn[indx]);
