new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
Spread1Y = data[.,7];
rating = data[.,8];

let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;

fileName = "cpm2";

_RiskMeasure = 1;
alpha = 0.999;
Risk0 = CreditRiskMeasure(fileName,alpha);
ExReturn0 = sumc(EaD .* (Euribor + Spread));

datName = fileName $+ "-cpm-portfolio-loss";
cpmLoss = loadd(datName);
datName = fileName $+ "-cpm-loan-loss";
loans = seqa(1,20,25);
cpmLoans = loadd(datName)';
nLoans = rows(loans);

Ns = 50000;
Risk = zeros(Ns,1);
ExReturn = zeros(Ns,1);
Risk[1] = Risk0;
ExReturn[1] = ExReturn0;

X0 = EaD[Loans];
X = X0;

t0 = hsec;
iter = 2;
do until iter > Ns;
  X = simul;
  L = cpmLoss + sumc(X .* cpmLoans ./ X0);
  Risk[iter] = quantile(L,alpha);
  EaD[loans] = X;
  ExReturn[iter] = sumc(EaD .* (Euribor + Spread)); 
  iter = iter + 1;
  if iter % 10 == 0;
    print /flush ftos(iter,"Iter = %lf",1,0);
  endif;
endo;

print etstr(hsec-t0);

tmp = Risk~ExReturn;
save cpm41 = tmp;

proc (1) = simul;
  local Y,nX,X,indx;
  Y = zeros(nLoans,1); 
  nX = ceil(rndu(1,1)*nloans);
  X = rndu(nX,1);
  indx = sortc(seqa(1,1,nLoans)~rndn(nLoans,1),2);
  Y[indx[1:nX,1]] = X;
  retp( Y * 25000 / sumc(Y) );
endp;
 