new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
Spread1Y = data[.,7];
rating = data[.,8];

let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 300;

ExReturn = EaD .* (Euribor + Spread);
I = rows(EaD);

fileName = "cpm2";
fmtName = fileName $+ "-loan-var";
load LoanVaR = ^fmtName;

alpha = 0.999;
_localQuantile_Bandwidth = 100;
_localQuantile_mtd = 2;
{VaR,DR,cRC} = CreditVaR_RiskContribution(fileName,alpha);

z = miss(cRC,0) ./ miss(LoanVaR,0);
/*
z = recode(z,cRC .== 0,0);
z = missrv(z,1);
*/

bp = zeros(7,1);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|2|4;
  _plwidth = 10; 
  _pbartyp = 6~3;
  xtics(-50,550,50,5);
  xlabel("\216Creance");
  ylabel("\216RC/VaR");
  e = ones(rows(bp)-1,1);
  _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~15);
  _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
  e = ones(rows(bp),1);
  _pmsgctl = bp+5~e.*(0.8~0.22~0~1~0~8);
  _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
  _pmsgstr = _pmsgstr $+ "\000\202\39\201";
  _pmsgctl = _pmsgctl | 4.62~0.22~0.17~0~2~0~6;
  ytics(0,1,0.20,2);
  graphprt("-c=1 -cf=cpm39.eps");
  bar(0,z);

