new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
Spread1Y = data[.,7];
rating = data[.,8];

let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;

ExReturn = EaD .* (Euribor + Spread);
I = rows(EaD);

fileName = "cpm2";
alpha = 0.999;
_localQuantile_Bandwidth = 100;
_localQuantile_mtd = 2;
{VaR,DR,cRC} = CreditVaR_RiskContribution(fileName,alpha);

RAPM = (ExReturn ./ miss(cRC,0)) / 1e4;

Table = zeros(7,4);
i = 1;
do until i > 7;
  j = 1;
  do until j > 4;
    tmp = selif(RAPM,indx_sector .== j .and rating .== i);
    Table[i,j] = meanc(packr(tmp));
    j = j + 1;
  endo;
  i = i + 1;
endo;

output file = cpm38.out reset;

call printfmt2(table',1,2);

output off;