new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
Spread1Y = data[.,7];
rating = data[.,8];

let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;

ExReturn = EaD .* (Euribor + Spread);
I = rows(EaD);

fileName = "cpm2";
alpha = 0.999;
_localQuantile_Bandwidth = 100;
_localQuantile_mtd = 2;
{VaR,DR,cRC} = CreditVaR_RiskContribution(fileName,alpha);

RAPM = 100 * (ExReturn ./ missex(cRC,cRC .<= 10)) / 1e4;

bp = zeros(7,1);
mRAPM = zeros(7,1);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  mRAPM[i] = median(packr(selif(rapm,rating .== i)));
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|2|4;
  _plwidth = 10; 
  _pbartyp = 6~12;
  xtics(0,500,100,5);
  xlabel("\216Creance");
  ylabel("\216RAPM (en %)");
  e = ones(rows(bp)-1,1);
  _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~15~15);
  _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
  e = ones(rows(bp),1);
  _pmsgctl = bp+5~e.*(190~0.2~0~1~0~10);
  _pmsgctl[1,1] = -10;
  ytics(0,100,20,2);
  graphprt("-c=1 -cf=cpm36.eps");
  bar(0,rapm);
