new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
Spread1Y = data[.,7];
rating = data[.,8];

let mulSpread = 2 1.9 1.8 1.7 1.5 1.4 1.2;
Spread = Spread1Y .* recode(rating, rating .== seqa(1,1,7)', mulSpread); 
Euribor = 500;

ExReturn = EaD .* (Euribor + Spread);
I = rows(EaD);

fileName = "cpm2";
fmtName = fileName $+ "-loan-var";

CreditVaR = zeros(I,1);
maxSize = 20;
maxBlock = 1000;

datName = fileName $+ "-loan-loss";
open fh = ^datName for read;
Ns = rowsf(fh);

Loss = zeros(Ns,maxSize);
alpha = 0.999;

cn = 1;
do until cn > 25;
  call seekr(fh,1);
  iter = 1;
  do until eof(fh);
    Loss[1+(iter-1)*maxBlock:iter*maxBlock,.] = 
           submat(readr(fh,maxBlock),0,seqa(1+(cn-1)*maxSize,1,maxSize));
    iter = iter + 1;    
  endo;

  CreditVaR[1+(cn-1)*maxSize:cn*MaxSize] = quantile(Loss,alpha)';

  print /flush ftos(cn,"Iteration %lf",1,0);
  
  save ^fmtName = CreditVar;

  cn = cn + 1;
endo;

call close(fh);

load CreditVaR = ^fmtName;

RAPM = 100 * (ExReturn ./ miss(CreditVaR,0)) / 1e4;

bp = zeros(7,1);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|2|4;
  _plwidth = 10; 
  _pbartyp = 6~3;
  xtics(-50,550,50,5);
  xlabel("\216Creance");
  ylabel("\216RAPM (en %)");
  e = ones(rows(bp)-1,1);
  _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~15);
  _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
  e = ones(rows(bp),1);
  _pmsgctl = bp+5~e.*(18~0.22~0~1~0~8);
  _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
  _pmsgstr = _pmsgstr $+ "\000\202\39\201";
  _pmsgctl = _pmsgctl | 4.59~0.22~0.17~0~2~0~6;
  ytics(0,20,5,5);
  graphprt("-c=1 -cf=cpm35.eps");
  bar(0,rapm);
