new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
spread = data[.,7];
rating = data[.,8];

bp = zeros(7,1);
mv = zeros(7,2);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  tmp = selif(spread,rating .== i);
  mv[i,1] = meanc(tmp);
  mv[i,2] = stdc(tmp);
  i = i + 1;
endo;

output file = cpm34.out reset;

call printfmt2(mv,1,0);

output off;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|2|4;
  _plwidth = 10; 
  _pbartyp = 6~3;
  xtics(-50,550,50,5);
  xlabel("\216Creance");
  ylabel("\216Spread (en pb)");
  e = ones(rows(bp)-1,1);
  _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~10);
  _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
  e = ones(rows(bp),1);
  _pmsgctl = bp+5~e.*(1200~0.22~0~1~0~8);
  _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
  _pmsgstr = _pmsgstr $+ "\000\202\39\201";
  _pmsgctl = _pmsgctl | 4.72~0.22~0.17~0~2~0~6;
  graphprt("-c=1 -cf=cpm34.eps");
  bar(0,spread);
