new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
rating = data[.,8];
indx_sector = data[.,2];

fileName = "cpm2";
_CreditRisk = 1;
rcName = fileName $+ ftos(_CreditRisk,"-rc-%lf",1,0);
load rc = ^rcName;
rc = rc';

alpha = 0.999;
rc = rc[.,3];

_localQuantile_Bandwidth = 50;
_localQuantile_mtd = 2;
{VaR,DR,cRC} = CreditVaR_RiskContribution(fileName,alpha);

rcTable = zeros(7,4);

i = 1;
do until i > 7;
  j = 1;
  do until j > 4;
    tmp = selif(cRC,indx_sector .== j .and rating .== i);
    rcTable[i,j] = sumc(tmp);
    j = j + 1;
  endo;
  i = i + 1;
endo;

rcTable = (rcTable | sumc(rcTable)' ) ~ ( sumc(rcTable') | sumc(sumc(rcTable)) );

output file = cpm33.out reset;

call printfmt2(rcTable,1,0);

output off;