new;
library gdr,pgraph;

L0 = PortfolioLoss("cpm2");
_Kernel = 0|1e5|128|1|0|error(0);
d = zeros(128,5);
{L0,d0,F,retcode} = Kernel(L0);

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
spread = data[.,7];
rating = data[.,8];

rho = 0.25;

proc invCDF(alpha);
  local RC;
  alpha = alpha';
  RC = EaD .* muLGD .* cdfn( (cdfni(PD) - sqrt(rho)*cdfni(1-alpha))/sqrt(1-rho) );
  retp(sumc(RC));
endp;

proc (2) = PDF(alpha);
  local L,Q;
  L = invCDF(alpha);
  alpha = alpha';
  Q = pdfn( (cdfni(PD) - sqrt(rho)*cdfni(1-alpha))/sqrt(1-rho) ) .* sqrt(rho) ./ sqrt(1-rho) ./ pdfn(cdfni(1-alpha));
  retp(L,1./sumc(EaD .* muLGD .* Q));
endp;

proc dev(rho);
  local alpha,RC;
  alpha = 0.999;
  RC = EaD .* muLGD .* cdfn( (cdfni(PD) - sqrt(rho)*cdfni(1-alpha))/sqrt(1-rho) );
  retp(sumc(RC) - 94203);
endp;

implied_rho = Bisection(&dev,0.20,0.50,0.001);
  
alpha_min = 1e-8;
alpha_max = 1-1e-8;
n_alpha = _Kernel[3];
h_alpha = (alpha_max-alpha_min)/(n_alpha+1);
alpha = seqa(alpha_min,h_alpha,n_alpha);

rho = implied_rho;
{L1,d1} = PDF(alpha);

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  setwind(1);

    _pdate = ""; _pnum = 2; _pframe = 0;
    _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|4;
    _pysci = 1;
    fonts("simplex simgrma complex");
    xlabel("\216Perte");
    xtics(0,1e5,0.20e5,2); 
    _plegstr = "Modele interne\000Modele Bale II (\202r\201 = 28,9%)";
    _plegctl = {2 5 5 4};
    xy(L0~L1,d0~d1);

  setwind(2);
    xlabel(""); _plegctl = 0; _paxes = 0;
    _pmsgstr = "\203\45\201\000\203\45\201\000\201\94";
    _pmsgctl = 6.19~4.59~0.07~-40~2~0~4 |
               6.19~4.32~0.07~-40~2~0~4 |
               6.72~4.22~0.12~0~2~0~4 ;
    draw;

    graphprt("-c=1 -cf=cpm33.eps");
  
  endwind;


