new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
rating = data[.,8];

fileName = "cpm2";
_CreditRisk = 1;
rcName = fileName $+ ftos(_CreditRisk,"-rc-%lf",1,0);
load rc = ^rcName;
rc = rc';

alpha = 0.999;
VaR = CreditRiskMeasure(fileName,alpha);

_localQuantile_Bandwidth = 50;
_localQuantile_mtd = 0;
{VaR0,DR0,RC0} = CreditVaR_RiskContribution(fileName,alpha);
_localQuantile_mtd = 1;
{VaR1,DR1,RC1} = CreditVaR_RiskContribution(fileName,alpha);
_localQuantile_mtd = 2;
{VaR2,DR2,RC2} = CreditVaR_RiskContribution(fileName,alpha);

bp = zeros(7,1);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|2|4;
  _plwidth = 10; 
  _pbartyp = 6~5;
  xtics(-50,550,50,5);
  xlabel("\216Creance");
  ylabel("\216RC");
  e = ones(rows(bp)-1,1);
  _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~15);
  _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
  e = ones(rows(bp),1);
  _pmsgctl = bp+5~e.*(575~0.22~0~1~0~8);
  _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
  _pmsgstr = _pmsgstr $+ "\000\202\39\201";
  _pmsgctl = _pmsgctl | 4.64~0.22~0.17~0~2~0~6;
  graphprt("-c=1 -cf=cpm32.eps");
  bar(0,RC2);