new;
library gdr,pgraph;
gdrSet;

rndseed 123;

rho = 0.5;
n = 50000;
let alpha = 0.99;
Sigma = xpnd(1|rho|1);
let x = 100 50;
VaR = cdfni(alpha') .* sqrt(x'Sigma*x);
d = cdfni(alpha') .* (Sigma*x) / sqrt(x'Sigma*x);

nr = 500;
Q1 = zeros(nr,1);
Q2 = Q1; Q3 = Q1; Q4 = Q1; Q5 = Q1;
dVaR1 = zeros(nr,2);
dVaR2 = dVaR1; dVaR3 = dVaR1; dVaR4 = dVaR1; dVaR5 = dVaR1;

i = 1;
do until i > Nr;
  u1 = rndn(n,1);
  u2 = rho .* u1 + sqrt(1-rho^2) .* rndn(n,1);
  u = u1~u2;
  P = u*x;

  _localQuantile_mtd = 0;
  Q1[i] = localQuantile(P,alpha);
  dVaR1[i,.] = sumc(_localQuantile_weight[.,2] .* u[_localQuantile_weight[.,1],.])';

  _localQuantile_bandwidth = 5;

  _localQuantile_mtd = 1;
  Q2[i] = localQuantile(P,alpha);
  dVaR2[i,.] = sumc(_localQuantile_weight[.,2] .* u[_localQuantile_weight[.,1],.])';

  _localQuantile_mtd = 2;
  Q3[i] = localQuantile(P,alpha);
  dVaR3[i,.] = sumc(_localQuantile_weight[.,2] .* u[_localQuantile_weight[.,1],.])';

  _localQuantile_bandwidth = 20;

  _localQuantile_mtd = 1;
  Q4[i] = localQuantile(P,alpha);
  dVaR4[i,.] = sumc(_localQuantile_weight[.,2] .* u[_localQuantile_weight[.,1],.])';

  _localQuantile_mtd = 2;
  Q5[i] = localQuantile(P,alpha);
  dVaR5[i,.] = sumc(_localQuantile_weight[.,2] .* u[_localQuantile_weight[.,1],.])';

  i = i + 1;
endo;

Q = Q1~Q2~Q3~Q4~Q5;
d1 = dVaR1[.,1]~dVaR2[.,1]~dVaR3[.,1]~dVaR4[.,1]~dVaR5[.,1];
d2 = dVaR1[.,2]~dVaR2[.,2]~dVaR3[.,2]~dVaR4[.,2]~dVaR5[.,2];

d_Q = zeros(128,5);
d_d1 = zeros(128,5);
d_d2 = zeros(128,5);

i = 1;
do until i > 5;
  _Kernel[1:2] = 280|340;
  {x_q,d_q[.,i],F,retcode} = Kernel(Q[.,i]);
  _Kernel[1:2] = 1.5|3;
  {x_d1,d_d1[.,i],F,retcode} = Kernel(d1[.,i]);
  _Kernel[1:2] = 1.25|2.25;
  {x_d2,d_d2[.,i],F,retcode} = Kernel(d2[.,i]);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|6|5;
  _pcolor = 2|1|4|0|5;
  _pstype = 8; _plctrl = 0|0|0|12|0; _psymsiz = 2.5;
  _plwidth = 10; 
  _pline = 1~3~VaR~0~VaR~100~1~0~15;
  xlabel("\216VaR");
  xtics(298,318,2,0);
 _plegstr = "Interpolation\000Noyau triangulaire (h = 5)\000"\
             "Noyau uniforme (h = 5)\000Noyau triangulaire (h = 20)\000"\
             "Noyau uniforme (h = 20)";
  _plegctl = {2 4 5.5 5};
  graphprt("-c=1 -cf=cpm31-1.eps");
  xy(x_q,missex(d_q,d_q .<= 1e-5));

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|6|5;
  _pcolor = 2|1|4|0|5;
  _pstype = 8; _plctrl = 0|0|0|12|0; _psymsiz = 2.5;
  _plwidth = 10; 
  _pline = 1~3~d[1]~0~d[1]~100~1~0~15;
  xlabel("\216MR(1)");
  xtics(1.5,3,0.25,5);
  ytics(0,7,1,2);
 _plegstr = "Interpolation\000Noyau triangulaire (h = 5)\000"\
             "Noyau uniforme (h = 5)\000Noyau triangulaire (h = 20)\000"\
             "Noyau uniforme (h = 20)";
  _plegctl = {2 4 5.5 5};
  graphprt("-c=1 -cf=cpm31-2.eps");
  xy(x_d1,missex(d_d1,d_d1 .<= 1e-5));

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|6|5;
  _pcolor = 2|1|4|0|5;
  _pstype = 8; _plctrl = 0|0|0|12|0; _psymsiz = 2.5;
  _plwidth = 10; 
  _pline = 1~3~d[2]~0~d[2]~100~1~0~15;
  xlabel("\216MR(2)");
  xtics(1.25,2.25,0.25,5);
  ytics(0,4,1,2);
 _plegstr = "Interpolation\000Noyau triangulaire (h = 5)\000"\
             "Noyau uniforme (h = 5)\000Noyau triangulaire (h = 20)\000"\
             "Noyau uniforme (h = 20)";
  _plegctl = {2 4 5.5 5};
  graphprt("-c=1 -cf=cpm31-3.eps");
  xy(x_d2,d_d2);

