new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
spread = data[.,7];
rating = data[.,8];

fileName = "cpm2";
_RiskMeasure = 1;
alpha = 0.95|0.99|0.999;
rcName = fileName $+ ftos(_RiskMeasure,"-rc-%lf",1,0);
load rc = ^rcName;
rc = rc';

rcTable1 = zeros(4,2);
rcTable2 = zeros(4,2);
rcTable3 = zeros(4,2);
nTable = zeros(4,1);

j = 1;
do until j > 4;
  tmp = selif(rc,indx_sector .== j);
  nTable[j] = rows(tmp);
  rcTable1[j,1] = sumc(tmp[.,1]);
  rcTable2[j,1] = sumc(tmp[.,2]);
  rcTable3[j,1] = sumc(tmp[.,3]);
  j = j + 1;
endo;

j = 1;
do until j > 4;
  indx = selif(seqa(1,1,rows(indx_sector)),indx_sector .== j);
  RC = DiscreteRiskContribution(fileName,alpha,indx);
  rcTable1[j,2] = RC[1];
  rcTable2[j,2] = RC[2];
  rcTable3[j,2] = RC[3];
  j = j + 1;
endo;

alpha = 0.95|0.99|0.999;
Risk = CreditRiskMeasure(fileName,alpha);
rcTable1 = rcTable1 | sumc(rcTable1)';
rcTable2 = rcTable2 | sumc(rcTable2)';
rcTable3 = rcTable3 | sumc(rcTable3)';

rcTable1 = rcTable1 | Risk[1].*ones(1,cols(rcTable1));
rcTable2 = rcTable2 | Risk[2].*ones(1,cols(rcTable1));
rcTable3 = rcTable3 | Risk[3].*ones(1,cols(rcTable1));

output file = cpm29.out reset;

call printfmt2(rcTable1,1,0);
print;
call printfmt2(rcTable2,1,0);
print;
call printfmt2(rcTable3,1,0);

output off;



