new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
spread = data[.,7];
rating = data[.,8];

fileName = "cpm2";
_RiskMeasure = 3;
alpha = 0.95|0.99|0.999;
rcName = fileName $+ ftos(_RiskMeasure,"-rc-%lf",1,0);
load rc = ^rcName;
rc = rc';

rcTable1 = zeros(7,4);
rcTable2 = zeros(7,4);
rcTable3 = zeros(7,4);
nTable = zeros(7,4);

i = 1;
do until i > 7;
  j = 1;
  do until j > 4;
    tmp = selif(rc,indx_sector .== j .and rating .== i);
    nTable[i,j] = rows(tmp);
    rcTable1[i,j] = sumc(tmp[.,1]);
    rcTable2[i,j] = sumc(tmp[.,2]);
    rcTable3[i,j] = sumc(tmp[.,3]);
    j = j + 1;
  endo;
  i = i + 1;
endo;

rcTable1 = rcTable1 ./ (1000*nTable);
rcTable2 = rcTable2 ./ (1000*nTable);
rcTable3 = rcTable3 ./ (1000*nTable);

alpha = 0.95|0.99|0.999;
Risk = CreditRiskMeasure(fileName,alpha);

output file = cpm27.out reset;

print sumc(RC)./Risk;
print;
call printfmt2(100*rcTable1',1,2);
print;
call printfmt2(100*rcTable2',1,2);
print;
call printfmt2(100*rcTable3',1,2);

output off;



