new;
library gdr,pgraph;
gdrSet;

fileName = "portfolio-1";
load data = ^fileName;
indx_loan = data[.,1];
indx_sector = data[.,2];
EaD = data[.,3];
muLGD = data[.,4];
sigmaLGD = data[.,5];
PD = data[.,6];
spread = data[.,7];
rating = data[.,8];

fileName = "cpm2";
_RiskMeasure = 1;
alpha = 0.95|0.99|0.999;
rcName = fileName $+ ftos(_RiskMeasure,"-rc-%lf",1,0);
load rc = ^rcName;
rc = rc';

bp = zeros(7,1);

i = 1;
do until i > 7;
  bp[i] = maxindc(rating .== i);
  i = i + 1;
endo;

rc_rating = rc;
bp_rating = bp;

load rc = ^rcName;
rc = rc';

data = sortc(indx_sector~rc,1);
rc = data[.,2:4];
bp = zeros(4,1);

i = 1;
do until i > 4;
  bp[i] = maxindc(data[.,1] .== i);
  i = i + 1;
endo;

rc_sector = rc;
bp_sector = bp;

graphset;
  begwind;
  window(2,2,0);

    fonts("simplex simgrma");
    _pdate = ""; _pnum = 2; _pframe = 0;
    _paxht = 0.20; _ptitlht = 0.25;

    xtics(-50,550,50,5);
    xlabel("\216Creance");
    ylabel("\216IVaR");

    pmsgstr = "\000\202\39\201";
    pmsgctl = 4.64~0.24~0.20~0~2~0~6;

  bp = bp_rating;
  rc = rc_rating;

  setwind(1);
    title("\216Rating / \202a\201 = 95%");
    _pbartyp = 6~1;
    e = ones(rows(bp)-1,1);
    _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~10);
    _pmsgstr = "AAA\000AA\000A\000BBB\000BB\000B\000CCC";
    _pmsgstr = _pmsgstr $+ pmsgstr;
    e = ones(rows(bp),1);
    _pmsgctl = bp+5~e.*(475~0.22~0~1~0~8);
    _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
    _pmsgctl = _pmsgctl | pmsgctl;
    ytics(0,500,100,2);
    bar(0,rc[.,1]);

  setwind(2);
    title("\216Rating / \202a\201 = 99,9%");
    _pbartyp = 6~2;
    _pmsgctl = bp+5~e.*(675~0.22~0~1~0~8);
    _pmsgctl[.,1] = _pmsgctl[.,1] + (-35|15|30|40|15|10|10);
    _pmsgctl = _pmsgctl | pmsgctl;
    ytics(0,700,100,2);
    bar(0,rc[.,3]);

  bp = bp_sector;
  rc = rc_sector;

  setwind(3);
    title("\216Secteur / \202a\201 = 95%");
    _pbartyp = 6~3;
    e = ones(rows(bp)-1,1);
    _pline = e.*(1~3)~trimr(bp,1,0)~e*0~trimr(bp,1,0)~e.*(5000~1~0~10);
    _pmsgstr = "S1\000S2\000S3\000S4";
    _pmsgstr = _pmsgstr $+ pmsgstr;
    e = ones(rows(bp),1);
    _pmsgctl = bp+5~e.*(475~0.22~0~1~0~8);
    _pmsgctl[.,1] = _pmsgctl[.,1] + (10|50|5|50);
    _pmsgctl = _pmsgctl | pmsgctl;
    ytics(0,500,100,2);
    bar(0,rc[.,1]);

  setwind(4);
    title("\216Secteur / \202a\201 = 99,9%");
    _pbartyp = 6~4;
    _pmsgctl = bp+5~e.*(675~0.22~0~1~0~8);
    _pmsgctl[.,1] = _pmsgctl[.,1] + (10|50|5|50);
    _pmsgctl = _pmsgctl | pmsgctl;
    ytics(0,700,100,2);
    bar(0,rc[.,3]);

    graphprt("-c=1 -cf=cpm24.eps");

  endwind;
