new;
library gdr,pgraph;
gdrSet;

let string fileNames[3] = "cpm15" "cpm16" "cpm17";

alpha = seqa(0.95,0.01,5)|seqa(0.991,0.0001,81);
K = seqa(0.5e5,0.5e5/(rows(alpha)-1),rows(alpha));
Risk = zeros(rows(alpha),3);

_RiskMeasure = 1;
i = 1;
do until i > 3;
  Risk[.,i] = CreditRiskMeasure(fileNames[i],alpha);
  i = i + 1;
endo;
VaR = Risk;

_RiskMeasure = 2;
i = 1;
do until i > 3;
  Risk[.,i] = CreditRiskMeasure(fileNames[i],K);
  i = i + 1;
endo;
ER = Risk;

_RiskMeasure = 3;
i = 1;
do until i > 3;
  Risk[.,i] = CreditRiskMeasure(fileNames[i],alpha);
  i = i + 1;
endo;
ES = Risk;

_RiskMeasure = 4;
i = 1;
do until i > 3;
  Risk[.,i] = CreditRiskMeasure(fileNames[i],alpha);
  i = i + 1;
endo;
UL = Risk;

graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _ptitlht = 0.30; _paxht = 0.25; _pnumht = 0.20;
  _plwidth = 10; 
/*
  xtics(0.95,1,0.01,2);
  ytics(0,1.5e5,0.5e5,5);
*/
  _pltype = 6|1|3; _pcolor = 2|1|4;
  _plegstr = "LGD #1\000LGD #2\000LGD #3";

  setwind(1);
    title("\216VaR");
    xlabel("\216\202a\201");
    xtics(0.95,1,0.01,2);
    xy(alpha,VaR);

  setwind(2);
    title("\216ER");
    xlabel("\216Seuil");
    ytics(6e4,1.1e5,1e4,0);
    xtics(0.5e5,1e5,0.1e5,2);
    xy(K,ER);

    _pyscale = 0;

  setwind(3);
    title("\216ES");
    xlabel("\216\202a\201");
    xtics(0.95,1,0.01,2);
    xy(alpha,ES);

  setwind(4);
    title("\216UL");
    xlabel("\216\202a\201");
    xtics(0.95,1,0.01,2);
    _plegctl = {2 5 3 4};
    xy(alpha,UL);

    graphprt("-c=1 -cf=cpm21.eps");

  endwind;

  
