new;
library gdr,pgraph;
gdrSet;

tau = 0.5;

proc FindParameter(theta);
  retp((-KendallCopulaFrank(theta) + tau)^2);
endp;

{theta,f0,g0,retcode} = Qnewton(&FindParameter,7);

/*

beta1 = 1; beta2 = 2;
beta3 = 0.5; beta4 = 3;

proc phi(x);
  local y;
  y = x^(1/beta1); y = (beta3+beta4)*y ./ (beta3*y+beta4);
  y = sin(pi/2*y); y = y^(1/beta2);
  retp(y);
endp;

proc invphi(x);
  local y;
  y = x^beta2; y = 2/pi*arcsin(y);
  y = beta4*y ./ (-beta3*y+beta4+beta3); y = y^beta1;
  retp(y);
endp;

*/

beta1 = 1; beta2 = 1;
beta3 = 1; beta4 = 0.025;

proc phi(x);
  local y;
  x = x^(1/beta1); y = (beta3+beta4)*x ./ (beta3*x+beta4) ;
  retp( y^(1/beta2) );
endp;

proc invphi(x);
  local y;
  x = x^beta2; y = beta4*x ./ (-beta3*x+beta4+beta3) ;
  retp( y^beta1 );
endp;

proc cdfCopula(u1,u2);
  retp( invphi(cdfCopulaFrank(phi(u1),phi(u2),theta)) );
endp;

proc pdfCopula(u1,u2);
  retp( ComputePdfCopula2(&cdfCopula,u1,u2) );
endp;

x1 = seqa(-3,0.01,601); x2 = x1';
u1 = seqa(0.01,0.01,99); u2 = u1';

pdf1 = pdfCopula(u1,u2);
pdf2 = pdfCopula(cdfn(x1),cdfn(x2)) .* pdfn(x1) .* pdfn(x2);
pdf3 = pdfCopula(cdfn(x1),cdft(x2,2)) .* pdfn(x1) .* pdft(x2,2);
pdf4 = pdfCopula(cdft(x1,1),cdft(x2,5)) .* pdft(x1,1) .* pdft(x2,5);

graphset;
  begwind;
  window(2,2,0);
  _pnum = 2; _paxht = 0.25; _pnumht = 0.20;
  fonts("simplex simgrma");
  _pzclr = 9|10|11|12|13|14|15|9|10|11|12|13|14|15|9|10|11|12|13|14|15;

  setwind(1);
    _plev = seqa(0.25,0.25,7)|seqa(1.5,0.1,50);
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);    
    xlabel("\214u]1["); ylabel("\214u]2[");
    contour(u1',u2',pdf1');

    _plev = 0.01|seqa(0.005,0.0075,60);
    xtics(-3,3,1,2); ytics(-3,3,1,2);

  setwind(2);
    xlabel("\214N(0,1)"); ylabel("\214N(0,1)");
    contour(x1',x2',pdf2');

  setwind(3);
    xlabel("\214N(0,1)"); ylabel("\214t]2[");
    contour(x1',x2',pdf3');

  setwind(4);
    xlabel("\214t]1["); ylabel("\214t]5[");
    contour(x1',x2',pdf4');

  endwind;

