new;
library gdr,pgraph;
gdrSet;

_copula_rankindx = 1;

dataset = "lme";
let vars  = AL CU;

data = ln(LoadData(dataset,vars));
data = packr(data - lag1(data));
x1 = data[.,1]; x2 = data[.,2]; 

theta_ml = 4.597625;
theta_ifm = 4.440463;
theta_om = 3.578972;

tau = KendallTau(x1,x2);

proc FindParameter1(theta);
  retp((-KendallCopulaFrank(theta) + tau)^2);
endp;

{theta_kendall,f0,g0,retcode} = Qnewton(&FindParameter1,2);

varrho = SpearmanRho(x1,x2);

proc FindParameter2(theta);
  retp((-SpearmanCopulaFrank(theta) + varrho)^2);
endp;

{theta_spearman,f0,g0,retcode} = Qnewton(&FindParameter2,2);

theta = theta_ml | theta_ifm | theta_om | theta_kendall | theta_spearman;
tau = zeros(5,1);
varrho = zeros(5,1);
i = 1;
do until i > 5;
  tau[i] = KendallCopulaFrank(theta[i]);
  varrho[i] = SpearmanCopulaFrank(theta[i]);
  i = i + 1;
endo;

output file = sklar54.out reset;

print theta~tau~varrho;

output off;