new;
library gdr,optmum,pgraph;
gdrSet;

_copula_rankindx = 1;

dataset = "lme";
let vars  = AL CU;

data = ln(LoadData(dataset,vars));
data = packr(data - lag1(data));
x1 = data[.,1]; x2 = data[.,2]; 

proc pdfCopula(u1,u2,theta);
  retp( pdfCopulaFrank(u1,u2,theta) );
endp;

u = Dependogram(data);
u1 = u[.,1]; u2 = u[.,2];

proc omProc(data,theta);
  retp( ln(pdfCopula(data[.,1],data[.,2],theta)) );
endp;

theta_om = mle(u,&omProc,2);

m = meanc(data);
sigma = stdc(data);
u1 = cdfn((x1-m[1])/sigma[1]);
u2 = cdfn((x2-m[2])/sigma[2]);
u = u1~u2;

theta_ifm = mle(u,&omProc,2);

sv = m[1]|sigma[1]|m[2]|sigma[2]|theta_ifm;

proc mlProc(data,theta);
  local m1,sigma1,m2,sigma2,thetaCopula,u1,u2;
  m1 = theta[1];
  sigma1 = sqrt(theta[2]^2);
  m2 = theta[3];
  sigma2 = sqrt(theta[4]^2);
  thetaCopula = theta[5];
  u1 = cdfn((data[.,1]-m1)/sigma1);
  u2 = cdfn((data[.,2]-m2)/sigma2);
  retp( ln( pdfCopula(u1,u2,thetaCopula) ) + 
        ln(pdfn((data[.,1]-m1)/sigma1)/sigma1) +
        ln(pdfn((data[.,2]-m2)/sigma2)/sigma2) );
endp;

theta_ml = submat(mle(data,&mlProc,sv),5,1);

output file = sklar53.out reset;

print theta_ml|theta_ifm|theta_om;

output off;