new;
library gdr,pgraph;
gdrSet;

_copula_rankindx = 1;

dataset = "lme";
let vars  = AL CU;

data = ln(LoadData(dataset,vars));
data = packr(data - lag1(data));

u = 0.0001|seqa(0.01,0.01,99);
K1 = CopulaKstat(data,u);

theta = 1~1.5~2~3;
phi = (-ln(u))^theta;
dphi = theta .* ((-ln(u))^(theta-1)).* (-1./u);
K2 = u - phi./dphi;

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  fonts("simplex simgrma");
  _pltype = 3|3|3|3|6; _plctrl = 5|5|5|5|0; _plwidth = 10; 
  _pstype = 8|9|10|11; _pcolor = 1|2|4|5|0;
  xtics(0,1,0.1,2); ytics(-0.4,0,0.1,2); 
  xlabel("\216u"); ylabel("\216u-K(u)");
  _plegstr = "\202Q\201 = 1\000\202Q\201 = 1,5\000\202Q\201 = 2\000\202Q\201 = 3\000K(u) empirique";
  _plegctl = {2 5 6.35 1.25};
  graphprt("-c=1 -cf=sklar51.eps");
  xy(u,u-(K2~K1));


