new;
library gdr,pgraph;
gdrSet;

_copula_rankindx = 1;

dataset = "lme";
let vars  = AL AL-15;

data = ln(LoadData(dataset,vars));
data = packr(data - lag1(data));
u = Dependogram(data);
u1 = u[.,1]; u2 = u[.,2];
rho = submat(corrx(data),1,2);

alpha = seqa(0,0.005,200)|seqa(0.996,0.0005,8);
q = zeros(rows(alpha),1);

i = 1;
do until i > rows(alpha);
  in = InCovarianceEllipseCopulaNormal2(u1,u2,rho,alpha[i]);
  q[i] = sumc(in)/rows(in);
  i = i + 1;
endo;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(3.5,2.5,4.75,1.25,1);
  fonts("simplex simgram");

  setwind(1);
    _pltype = 1|3; _pnum = 2; _pframe = 0; _pframe = 0; _pdate = ""; _pcolor = 1;
    _pltype = 6; _plwidth = 10; 
    fonts("simplex simgrma");
    xlabel("\216\202a\201");
    ylabel("\216q\202\34av\201");
    _pline = 1~3~0~0~1~1~1~12~10;
    xy(alpha,q);

  setwind(2);
    _pline = 0; _pltype = 3; _paxht = 0.35; _pnumht = 0.25;
    xlabel("\216\202a\201");
    ylabel("\216(1-q)/(1-\202a\201)");
    ytics(0,3,1,2);
    xy(alpha,(1-q)./(1-alpha));

    graphprt("-c=1 -cf=sklar50.eps");

  endwind;

